/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.message.SdbMsgHeader;
import com.sequoiadb.message.request.Request;
import com.sequoiadb.util.Helper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class SdbRequest
extends SdbMsgHeader
implements Request {
    protected SdbRequest() {
        this.length = 28;
    }

    @Override
    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int opCode() {
        return this.opCode;
    }

    @Override
    public void encode(ByteBuffer out) {
        this.encodeMsgHeader(out);
        this.encodeBody(out);
    }

    protected void encodeMsgHeader(ByteBuffer out) {
        out.putInt(this.length);
        out.putInt(this.opCode);
        out.putInt(this.tid);
        out.putLong(this.routeId);
        out.putLong(this.requestId);
    }

    protected abstract void encodeBody(ByteBuffer var1);

    protected static void encodeBSONBytes(byte[] objBytes, ByteBuffer out) {
        if (out.order() == ByteOrder.BIG_ENDIAN) {
            Helper.bsonEndianConvert(objBytes, 0, objBytes.length, true);
        }
        out.put(objBytes);
        int paddingLen = Helper.alignedSize(objBytes.length) - objBytes.length;
        if (paddingLen > 0) {
            out.put(new byte[paddingLen]);
        }
    }
}

