/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.response;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.SysInfoHeader;
import com.sequoiadb.message.response.Response;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SysInfoResponse
extends SysInfoHeader
implements Response {
    private static final int LENGTH = 128;
    private int osType;
    private ByteOrder byteOrder;

    @Override
    public int length() {
        return 128;
    }

    @Override
    public int opCode() {
        return -1;
    }

    public int osType() {
        return this.osType;
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    @Override
    public void decode(ByteBuffer in) {
        in.order(ByteOrder.BIG_ENDIAN);
        this.specialSysInfoLen = in.getInt();
        this.eyeCatcher = in.getInt();
        if (this.eyeCatcher == -66052) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (this.eyeCatcher == -50462977) {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            throw new BaseException(SDBError.SDB_INVALIDARG, String.format("Invalid eyecatcher: %x", this.eyeCatcher));
        }
        in.order(this.byteOrder);
        this.realMsgLen = in.getInt();
        this.osType = in.getInt();
    }
}

