/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.util;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import org.bson.BSON;
import org.bson.BSONObject;

public final class Helper {
    public static final int ALIGN_SIZE = 4;

    private Helper() {
    }

    public static String md5(String str) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new BaseException(SDBError.SDB_SYS, (Throwable)e);
        }
        char[] charArray = str.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            byteArray[i] = (byte)charArray[i];
        }
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuilder hexValue = new StringBuilder();
        for (byte md5Byte : md5Bytes) {
            int val = md5Byte & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static int alignedSize(int original, int alignSize) {
        int size = original + alignSize - 1;
        size -= size % alignSize;
        return size;
    }

    public static int alignedSize(int original) {
        return Helper.alignedSize(original, 4);
    }

    public static byte[] encodeBSONObj(BSONObject obj) {
        return BSON.encode(obj);
    }

    public static BSONObject decodeBSONBytes(byte[] bytes) {
        return BSON.decode(bytes);
    }

    public static BSONObject decodeBSONObject(ByteBuffer in) {
        int position = in.position();
        int length = in.getInt(position);
        if (in.order() == ByteOrder.BIG_ENDIAN) {
            Helper.bsonEndianConvert(in.array(), position, length, false);
        }
        BSONObject obj = BSON.decode(in.array(), position);
        if (length < in.remaining()) {
            int alignedSize = Helper.alignedSize(length);
            in.position(alignedSize + position);
        } else {
            in.position(length + position);
        }
        return obj;
    }

    public static byte[] decodeBSONBytes(ByteBuffer in) {
        int position = in.position();
        int length = in.getInt(position);
        if (in.order() == ByteOrder.BIG_ENDIAN) {
            Helper.bsonEndianConvert(in.array(), position, length, false);
        }
        byte[] bytes = new byte[length];
        in.get(bytes);
        if (in.remaining() > 0) {
            int alignedSize = Helper.alignedSize(length);
            in.position(alignedSize + position);
        }
        return bytes;
    }

    public static int byteToInt(byte[] byteArray, boolean endianConvert) {
        if (byteArray == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        if (endianConvert) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            bb.order(ByteOrder.BIG_ENDIAN);
        }
        return bb.getInt();
    }

    public static int byteToInt(byte[] array, int begin) {
        if (array == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        ByteBuffer bb = ByteBuffer.allocate(4);
        for (int count = 0; count < 4; ++count) {
            bb.put(array[begin + count]);
        }
        return bb.getInt(0);
    }

    public static void bsonEndianConvert(byte[] inBytes, int offset, int objSize, boolean l2r) {
        int begin = offset;
        Helper.arrayReverse(inBytes, offset, 4);
        offset += 4;
        block17: while (offset < inBytes.length) {
            byte type = inBytes[offset];
            ++offset;
            if (type == 0) break;
            offset += Helper.getStrLength(inBytes, offset) + 1;
            switch (type) {
                case 1: {
                    Helper.arrayReverse(inBytes, offset, 8);
                    offset += 8;
                    break;
                }
                case 2: 
                case 13: 
                case 14: {
                    int length = Helper.byteToInt(inBytes, offset);
                    Helper.arrayReverse(inBytes, offset, 4);
                    int newLength = Helper.byteToInt(inBytes, offset);
                    offset += (l2r ? newLength : length) + 4;
                    break;
                }
                case 3: 
                case 4: {
                    int length = Helper.getBsonLength(inBytes, offset, l2r);
                    Helper.bsonEndianConvert(inBytes, offset, length, l2r);
                    offset += length;
                    break;
                }
                case 5: {
                    int length = Helper.byteToInt(inBytes, offset);
                    Helper.arrayReverse(inBytes, offset, 4);
                    int newLength = Helper.byteToInt(inBytes, offset);
                    offset += (l2r ? newLength : length) + 5;
                    break;
                }
                case -1: 
                case 6: 
                case 10: 
                case 127: {
                    break;
                }
                case 7: {
                    offset += 12;
                    break;
                }
                case 8: {
                    ++offset;
                    break;
                }
                case 9: {
                    Helper.arrayReverse(inBytes, offset, 8);
                    offset += 8;
                    break;
                }
                case 11: {
                    offset += Helper.getStrLength(inBytes, offset) + 1;
                    offset += Helper.getStrLength(inBytes, offset) + 1;
                    break;
                }
                case 12: {
                    int length = Helper.byteToInt(inBytes, offset += 12);
                    Helper.arrayReverse(inBytes, offset, 4);
                    int newLength = Helper.byteToInt(inBytes, offset);
                    offset += (l2r ? newLength : length) + 4;
                    offset += 12;
                    break;
                }
                case 15: {
                    Helper.arrayReverse(inBytes, offset, 4);
                    int length = Helper.byteToInt(inBytes, offset += 4);
                    Helper.arrayReverse(inBytes, offset, 4);
                    int newLength = Helper.byteToInt(inBytes, offset);
                    int objLength = Helper.getBsonLength(inBytes, offset += (l2r ? newLength : length) + 4, l2r);
                    Helper.bsonEndianConvert(inBytes, offset, objLength, l2r);
                    offset += objLength;
                    break;
                }
                case 16: {
                    Helper.arrayReverse(inBytes, offset, 4);
                    offset += 4;
                    break;
                }
                case 17: {
                    Helper.arrayReverse(inBytes, offset, 4);
                    Helper.arrayReverse(inBytes, offset += 4, 4);
                    offset += 4;
                    break;
                }
                case 18: {
                    Helper.arrayReverse(inBytes, offset, 8);
                    offset += 8;
                    break;
                }
                case 100: {
                    int length = Helper.byteToInt(inBytes, offset);
                    Helper.arrayReverse(inBytes, offset, 4);
                    int newLength = Helper.byteToInt(inBytes, offset);
                    Helper.arrayReverse(inBytes, offset += 4, 4);
                    Helper.arrayReverse(inBytes, offset += 4, 2);
                    Helper.arrayReverse(inBytes, offset += 2, 2);
                    offset += 2;
                    int ndigits = ((l2r ? newLength : length) - 12) / 2;
                    for (int i = 0; i < ndigits; ++i) {
                        Helper.arrayReverse(inBytes, offset, 2);
                        offset += 2;
                    }
                    continue block17;
                }
            }
        }
        if (offset - begin != objSize) {
            throw new BaseException(SDBError.SDB_INVALIDSIZE);
        }
    }

    private static int getBsonLength(byte[] inBytes, int offset, boolean endianConvert) {
        byte[] tmp = new byte[4];
        for (int i = 0; i < 4; ++i) {
            tmp[i] = inBytes[offset + i];
        }
        return Helper.byteToInt(tmp, endianConvert);
    }

    private static void arrayReverse(byte[] array, int begin, int length) {
        int i = begin;
        for (int j = begin + length - 1; i < j; ++i, --j) {
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    private static int getStrLength(byte[] array, int begin) {
        int length = 0;
        while (array[begin] != 0) {
            ++length;
            ++begin;
        }
        return length;
    }
}

