/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.types.BSONDecimal;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.bson.util.JSON;

public class BasicBSONObject
implements Map<String, Object>,
BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;
    private Map<String, Object> _objectMap = null;

    public BasicBSONObject(boolean sort) {
        this._objectMap = sort ? new TreeMap<String, Object>() : new LinkedHashMap<String, Object>();
    }

    public BasicBSONObject() {
        this(false);
    }

    public BasicBSONObject(int size) {
        this(false);
    }

    @Override
    public boolean isEmpty() {
        return this._objectMap.size() == 0;
    }

    public BasicBSONObject(String key, Object value) {
        this(false);
        this.put(key, value);
    }

    public BasicBSONObject(Map m) {
        this._objectMap = new LinkedHashMap<String, Object>(m);
    }

    @Override
    public Map toMap() {
        if (this._objectMap instanceof LinkedHashMap) {
            return new LinkedHashMap<String, Object>(this._objectMap);
        }
        return new TreeMap<String, Object>(this._objectMap);
    }

    @Override
    public Object removeField(String key) {
        return this._objectMap.remove(key);
    }

    @Override
    public boolean containsField(String field) {
        return this._objectMap.containsKey(field);
    }

    @Override
    @Deprecated
    public boolean containsKey(String key) {
        return this.containsField(key);
    }

    @Override
    public Object get(String key) {
        return this._objectMap.get(key);
    }

    public int getInt(String key) {
        Object o = this.get(key);
        if (o == null) {
            throw new NullPointerException("no value for: " + key);
        }
        return BSON.toInt(o);
    }

    public int getInt(String key, int def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return BSON.toInt(foo);
    }

    public long getLong(String key) {
        Object foo = this.get(key);
        return ((Number)foo).longValue();
    }

    public long getLong(String key, long def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return ((Number)foo).longValue();
    }

    public double getDouble(String key) {
        Object foo = this.get(key);
        return ((Number)foo).doubleValue();
    }

    public double getDouble(String key, double def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return ((Number)foo).doubleValue();
    }

    public String getString(String key) {
        Object foo = this.get(key);
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public String getString(String key, String def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return foo.toString();
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        if (foo instanceof Number) {
            return ((Number)foo).intValue() > 0;
        }
        if (foo instanceof Boolean) {
            return (Boolean)foo;
        }
        throw new IllegalArgumentException("can't coerce to bool:" + foo.getClass());
    }

    public ObjectId getObjectId(String field) {
        return (ObjectId)this.get(field);
    }

    public ObjectId getObjectId(String field, ObjectId def) {
        Object foo = this.get(field);
        return foo != null ? (ObjectId)foo : def;
    }

    public Date getDate(String field) {
        return (Date)this.get(field);
    }

    public Date getDate(String field, Date def) {
        Object foo = this.get(field);
        return foo != null ? (Date)foo : def;
    }

    public BigDecimal getBigDecimal(String field) {
        Object obj = this.get(field);
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return ((BSONDecimal)this.get(field)).toBigDecimal();
    }

    public BigDecimal getBigDecimal(String field, BigDecimal def) {
        Object foo = this.get(field);
        return foo != null ? (BigDecimal)foo : def;
    }

    @Override
    public Object put(String key, Object val) {
        return this._objectMap.put(key, val);
    }

    @Override
    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    public BasicBSONObject append(String key, Object val) {
        this.put(key, val);
        return this;
    }

    public String toString() {
        return JSON.serialize(this);
    }

    @Override
    public int hashCode() {
        return this._objectMap.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BSONObject)) {
            return false;
        }
        BSONObject other = (BSONObject)o;
        if (!this.keySet().equals(other.keySet())) {
            return false;
        }
        for (String key : this.keySet()) {
            Object a = this.get(key);
            Object b = other.get(key);
            if (a == null && b != null) {
                return false;
            }
            if (b == null) {
                if (a == null) continue;
                return false;
            }
            if (a instanceof Pattern && b instanceof Pattern) {
                Pattern p1 = (Pattern)a;
                Pattern p2 = (Pattern)b;
                if (p1.pattern().equals(p2.pattern()) && p1.flags() == p2.flags()) continue;
                return false;
            }
            if (a.equals(b)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean BasicTypeWrite(Object object, Object value, Method method) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> paramType = method.getParameterTypes()[0];
        boolean result = true;
        boolean numberCompare = false;
        if (paramType.isPrimitive()) {
            if (paramType.getName().equals("int")) {
                method.invoke(object, ((Number)value).intValue());
                return result;
            } else if (paramType.getName().equals("long")) {
                method.invoke(object, ((Number)value).longValue());
                return result;
            } else if (paramType.getName().equals("byte")) {
                method.invoke(object, ((Number)value).byteValue());
                return result;
            } else if (paramType.getName().equals("double")) {
                method.invoke(object, ((Number)value).doubleValue());
                return result;
            } else if (paramType.getName().equals("float")) {
                method.invoke(object, Float.valueOf(((Number)value).floatValue()));
                return result;
            } else if (paramType.getName().equals("short")) {
                method.invoke(object, ((Number)value).shortValue());
                return result;
            } else if (paramType.getName().equals("char")) {
                method.invoke(object, Character.valueOf(((Character)value).charValue()));
                return result;
            } else {
                if (!paramType.getName().equals("boolean")) return false;
                method.invoke(object, (boolean)((Boolean)value));
            }
            return result;
        }
        if ((paramType.getName().equals("java.lang.Integer") || paramType.getName().equals("java.lang.Long") || paramType.getName().equals("java.lang.Float") || paramType.getName().equals("java.lang.Double")) && (value.getClass().getName().equals("java.lang.Integer") || value.getClass().getName().equals("java.lang.Long") || value.getClass().getName().equals("java.lang.Float") || value.getClass().getName().equals("java.lang.Double"))) {
            numberCompare = true;
        }
        if (!(numberCompare || paramType.isInstance(value) || value.getClass().getName().equals("java.math.BigDecimal") || value.getClass().getName().equals("org.bson.types.BSONDecimal"))) {
            throw new IllegalArgumentException("The method: " + method.getName() + " Expected parameter type:" + paramType.getName() + " does not match with the actual type:" + value.getClass().getName());
        }
        result = true;
        if (String.class.isAssignableFrom(paramType)) {
            method.invoke(object, (String)value);
            return result;
        } else if (Date.class.isAssignableFrom(paramType)) {
            method.invoke(object, (Date)value);
            return result;
        } else if (Integer.class.isAssignableFrom(paramType)) {
            method.invoke(object, new Integer(((Number)value).intValue()));
            return result;
        } else if (Long.class.isAssignableFrom(paramType)) {
            method.invoke(object, new Long(((Number)value).longValue()));
            return result;
        } else if (Double.class.isAssignableFrom(paramType)) {
            method.invoke(object, new Double(((Number)value).doubleValue()));
            return result;
        } else if (Float.class.isAssignableFrom(paramType)) {
            method.invoke(object, new Float(((Number)value).floatValue()));
            return result;
        } else if (Character.class.isAssignableFrom(paramType)) {
            method.invoke(object, (Character)value);
            return result;
        } else if (ObjectId.class.isAssignableFrom(paramType)) {
            method.invoke(object, (ObjectId)value);
            return result;
        } else if (Boolean.class.isAssignableFrom(paramType)) {
            method.invoke(object, (Boolean)value);
            return result;
        } else if (Pattern.class.isAssignableFrom(paramType)) {
            method.invoke(object, (Pattern)value);
            return result;
        } else if (byte[].class.isAssignableFrom(paramType)) {
            method.invoke(object, new Object[]{(byte[])value});
            return result;
        } else if (Binary.class.isAssignableFrom(paramType)) {
            method.invoke(object, (Binary)value);
            return result;
        } else if (UUID.class.isAssignableFrom(paramType)) {
            method.invoke(object, (UUID)value);
            return result;
        } else if (Symbol.class.isAssignableFrom(paramType)) {
            method.invoke(object, (Symbol)value);
            return result;
        } else if (BSONTimestamp.class.isAssignableFrom(paramType)) {
            method.invoke(object, (BSONTimestamp)value);
            return result;
        } else if (BSONDecimal.class.isAssignableFrom(paramType)) {
            String className = value.getClass().getName();
            if (className.equals("java.math.BigDecimal")) {
                method.invoke(object, new BSONDecimal((BigDecimal)value));
                return result;
            } else {
                if (!className.equals("org.bson.types.BSONDecimal")) throw new IllegalArgumentException("The method: " + method.getName() + " Expected parameter type:" + paramType.getName() + " does not match with the actual type:" + className);
                method.invoke(object, (BSONDecimal)value);
            }
            return result;
        } else if (BigDecimal.class.isAssignableFrom(paramType)) {
            String className = value.getClass().getName();
            if (className.equals("java.math.BigDecimal")) {
                method.invoke(object, (BigDecimal)value);
                return result;
            } else {
                if (!className.equals("org.bson.types.BSONDecimal")) throw new IllegalArgumentException("The method: " + method.getName() + " Expected parameter type:" + paramType.getName() + " does not match with the actual type:" + className);
                method.invoke(object, ((BSONDecimal)value).toBigDecimal());
            }
            return result;
        } else if (CodeWScope.class.isAssignableFrom(paramType)) {
            method.invoke(object, (CodeWScope)value);
            return result;
        } else if (Code.class.isAssignableFrom(paramType)) {
            method.invoke(object, (Code)value);
            return result;
        } else if (MinKey.class.isAssignableFrom(paramType)) {
            method.invoke(object, (MinKey)value);
            return result;
        } else if (MaxKey.class.isAssignableFrom(paramType)) {
            method.invoke(object, (MaxKey)value);
            return result;
        } else {
            if (!List.class.isAssignableFrom(paramType)) return false;
            method.invoke(object, (List)value);
        }
        return result;
    }

    @Override
    public <T> T as(Class<T> cls) throws Exception {
        return this.as(cls, null);
    }

    @Override
    public <T> T as(Class<T> cls, Type eleType) throws Exception {
        boolean hasConsturctor = false;
        T result = null;
        for (Constructor<?> con : cls.getConstructors()) {
            if (con.getParameterTypes().length != 0) continue;
            result = (T)con.newInstance(new Object[0]);
            hasConsturctor = true;
            break;
        }
        if (!hasConsturctor) {
            throw new Exception("Class " + cls.getName() + " does not exist an default constructor method");
        }
        if (BSON.IsBasicType(result)) {
            throw new IllegalArgumentException("Not support as to basic type. type=" + cls.getName());
        }
        if (Collection.class.isAssignableFrom(cls) || Map.class.isAssignableFrom(cls) || cls.isArray()) {
            throw new IllegalArgumentException("Not support as to Collection/Map/Array type. type=" + cls.getName());
        }
        BeanInfo bi = Introspector.getBeanInfo(cls);
        PropertyDescriptor[] props = bi.getPropertyDescriptors();
        Object value = null;
        for (PropertyDescriptor p : props) {
            if (!this.containsField(p.getName())) continue;
            Method writeMethod = p.getWriteMethod();
            if (writeMethod == null) {
                throw new IllegalArgumentException("The property:" + cls.getName() + "." + p.getName() + " have no set method.");
            }
            value = this.get(p.getName());
            if (value == null) continue;
            if (p.getPropertyType().equals(Map.class)) {
                Field mapField = cls.getDeclaredField(p.getName());
                Type generictype = mapField.getGenericType();
                Type valueType = null;
                if (generictype instanceof ParameterizedType) {
                    Type[] types = ((ParameterizedType)generictype).getActualTypeArguments();
                    valueType = types[1];
                }
                Map map = ((BSONObject)value).toMap();
                HashMap<String, Object> realMap = new HashMap<String, Object>();
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    String key = entry.getKey().toString();
                    if (((Class)valueType).equals(Object.class)) {
                        Object v = entry.getValue();
                        if (BSON.IsBasicType(v)) {
                            realMap.put(key, v);
                            continue;
                        }
                        if (v instanceof BasicBSONList) {
                            realMap.put(key, ((BasicBSONList)v).asList());
                            continue;
                        }
                        if (v instanceof BasicBSONObject) {
                            realMap.put(key, ((BasicBSONObject)v).asMap());
                            continue;
                        }
                        throw new IllegalArgumentException("can't support in map. value_type=" + v.getClass());
                    }
                    if (((Class)valueType).isPrimitive() || ((Class)valueType).equals(String.class)) {
                        realMap.put(key, ((BSONObject)value).get(key));
                        continue;
                    }
                    Object tmpObj = ((BSONObject)value).get(key);
                    if (BSON.IsBasicType(tmpObj)) {
                        realMap.put(key, tmpObj);
                        continue;
                    }
                    realMap.put(key, ((BSONObject)tmpObj).as((Class)valueType));
                }
                writeMethod.invoke(result, realMap);
                continue;
            }
            if (value instanceof BasicBSONObject) {
                writeMethod.invoke(result, ((BSONObject)value).as(p.getPropertyType()));
                continue;
            }
            if (value instanceof BasicBSONList) {
                Field f = cls.getDeclaredField(p.getName());
                if (f == null) continue;
                Type _type = f.getGenericType();
                Type fileType = null;
                if (_type == null || !(_type instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Current version only support parameterized type Collection(List/Set/Queue) field. unknow type=" + _type.toString());
                }
                fileType = ((ParameterizedType)_type).getActualTypeArguments()[0];
                writeMethod.invoke(result, ((BSONObject)value).as(p.getPropertyType(), fileType));
                continue;
            }
            if (!this.BasicTypeWrite(result, value, writeMethod)) continue;
        }
        return result;
    }

    public Object asMap() {
        HashMap<String, Object> realMap = new HashMap<String, Object>();
        for (String key : this.keySet()) {
            Object v = this.get(key);
            if (v == null) continue;
            if (BSON.IsBasicType(v)) {
                realMap.put(key, v);
                continue;
            }
            if (v instanceof BasicBSONList) {
                realMap.put(key, ((BasicBSONList)v).asList());
                continue;
            }
            if (v instanceof BasicBSONObject) {
                realMap.put(key, ((BasicBSONObject)v).asMap());
                continue;
            }
            throw new IllegalArgumentException("can't support in map. value_type=" + v.getClass());
        }
        return realMap;
    }

    public static BSONObject typeToBson(Object object, Boolean ignoreNullValue) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        BSONObject result = null;
        if (object == null) {
            result = null;
        } else {
            if (BSON.IsBasicType(object)) {
                throw new IllegalArgumentException("Current version is not support basice type to bson in the top level.");
            }
            if (object instanceof List) {
                BasicBSONList listObj = new BasicBSONList();
                List list = (List)object;
                int index = 0;
                for (Object obj : list) {
                    if (BSON.IsBasicType(obj)) {
                        if (!ignoreNullValue.booleanValue() || null != obj) {
                            listObj.put(Integer.toString(index), obj);
                        }
                    } else {
                        BSONObject tmpObj = BasicBSONObject.typeToBson(obj, ignoreNullValue);
                        if (!ignoreNullValue.booleanValue() || null != tmpObj) {
                            listObj.put(Integer.toString(index), (Object)tmpObj);
                        }
                    }
                    ++index;
                }
                result = listObj;
            } else if (object instanceof Map) {
                BasicBSONObject mapObj = new BasicBSONObject();
                Map map = (Map)object;
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    String key = entry.getKey().toString();
                    Object value = entry.getValue();
                    if (BSON.IsBasicType(value)) {
                        if (ignoreNullValue.booleanValue() && null == value) continue;
                        mapObj.put(key, value);
                        continue;
                    }
                    BSONObject tmpObj = BasicBSONObject.typeToBson(value, ignoreNullValue);
                    if (ignoreNullValue.booleanValue() && null == value) continue;
                    mapObj.put(key, (Object)tmpObj);
                }
                result = mapObj;
            } else {
                if (object.getClass().isArray()) {
                    throw new IllegalArgumentException("Current version is not support Array type field.");
                }
                if (object instanceof BSONObject) {
                    result = (BSONObject)object;
                } else {
                    PropertyDescriptor[] props;
                    if (object.getClass().getName() == "java.lang.Class") {
                        throw new IllegalArgumentException("Current version is not support java.lang.Class type field.");
                    }
                    result = new BasicBSONObject();
                    Class<?> cl = object.getClass();
                    BeanInfo bi = Introspector.getBeanInfo(cl);
                    for (PropertyDescriptor p : props = bi.getPropertyDescriptors()) {
                        Class<?> type = p.getPropertyType();
                        Method readMethod = p.getReadMethod();
                        if (readMethod == null) {
                            throw new IllegalArgumentException("The property:" + cl.getName() + "." + p.getName() + " have no get method.");
                        }
                        Object propObj = readMethod.invoke(object, new Object[0]);
                        if (BSON.IsBasicType(propObj)) {
                            if (ignoreNullValue.booleanValue() && null == propObj) continue;
                            result.put(p.getName(), propObj);
                            continue;
                        }
                        if (type.getName() == "java.lang.Class") continue;
                        BSONObject tmpObj = BasicBSONObject.typeToBson(propObj, ignoreNullValue);
                        if (ignoreNullValue.booleanValue() && null == tmpObj) continue;
                        result.put(p.getName(), tmpObj);
                    }
                }
            }
        }
        return result;
    }

    public static BSONObject typeToBson(Object object) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return BasicBSONObject.typeToBson(object, false);
    }

    @Override
    public Set<String> keySet() {
        return this._objectMap.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this._objectMap.entrySet();
    }

    @Override
    public int size() {
        return this._objectMap.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._objectMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._objectMap.containsValue(value);
    }

    @Override
    public Object remove(Object key) {
        return this._objectMap.remove(key);
    }

    @Override
    public void clear() {
        this._objectMap.clear();
    }

    @Override
    public Collection<Object> values() {
        return this._objectMap.values();
    }

    @Override
    public Object get(Object key) {
        return this._objectMap.get(key);
    }
}

