/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BSONTimestamp
implements Serializable {
    private static final long serialVersionUID = -3268482672267936464L;
    static final boolean D = Boolean.getBoolean("DEBUG.DBTIMESTAMP");
    final int _inc;
    final Date _time;

    public BSONTimestamp() {
        this._inc = 0;
        this._time = new Date(0L);
    }

    public BSONTimestamp(int time, int inc) {
        if (inc < 0 || inc >= 1000000) {
            time += inc / 1000000;
            if ((inc %= 1000000) < 0) {
                --time;
                inc += 1000000;
            }
        }
        this._time = new Date((long)time * 1000L);
        this._inc = inc;
    }

    public BSONTimestamp(Date date) {
        this((int)(date.getTime() / 1000L), (int)(date.getTime() % 1000L) * 1000);
    }

    public BSONTimestamp(Timestamp timestamp) {
        this((int)(timestamp.getTime() / 1000L), timestamp.getNanos() / 1000);
    }

    public Date toDate() {
        return new Date((long)this.getTime() * 1000L + (long)this.getInc() / 1000L);
    }

    public Timestamp toTimestamp() {
        Timestamp ts = new Timestamp((long)this.getTime() * 1000L);
        ts.setNanos(this.getInc() * 1000);
        return ts;
    }

    public int getTime() {
        if (this._time == null) {
            return 0;
        }
        return (int)(this._time.getTime() / 1000L);
    }

    public int getInc() {
        return this._inc;
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
        String strDate = formatter.format(this._time);
        return "{ $timestamp : " + strDate + "." + this._inc + " }";
    }

    public Date getDate() {
        if (this._time == null) {
            return null;
        }
        return this._time;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BSONTimestamp) {
            BSONTimestamp t2 = (BSONTimestamp)obj;
            return this.getTime() == t2.getTime() && this.getInc() == t2.getInc();
        }
        return false;
    }
}

