/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.Serializable;
import java.util.Arrays;
import org.bson.util.JSON;

public class Binary
implements Serializable {
    private static final long serialVersionUID = 7902997490338209467L;
    private final byte type;
    private final byte[] data;

    public Binary(byte[] data) {
        this(0, data);
    }

    public Binary(byte type, byte[] data) {
        this.type = type;
        this.data = data;
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Binary)) {
            return false;
        }
        Binary other = (Binary)obj;
        return this.type == other.type && Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public String toString() {
        return JSON.serialize(this);
    }
}

