/*
 * Decompiled with CFR 0.152.
 */
package com.serjltt.moshi.adapters;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;

public final class DefaultOnDataMismatchAdapter<T>
extends JsonAdapter<T> {
    private final JsonAdapter<T> delegate;
    private final T defaultValue;

    DefaultOnDataMismatchAdapter(JsonAdapter<T> delegate, T defaultValue) {
        this.delegate = delegate;
        this.defaultValue = defaultValue;
    }

    public T fromJson(JsonReader reader) throws IOException {
        Object jsonValue = reader.readJsonValue();
        try {
            return (T)this.delegate.fromJsonValue(jsonValue);
        }
        catch (JsonDataException ignore) {
            return this.defaultValue;
        }
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        this.delegate.toJson(writer, value);
    }

    public String toString() {
        return this.delegate + ".defaultOnDatMisMatch(" + this.defaultValue + ')';
    }

    public static <T> JsonAdapter.Factory newFactory(final Type type, final T defaultValue) {
        return new JsonAdapter.Factory(){

            public JsonAdapter<?> create(Type requestedType, Set<? extends Annotation> annotations, Moshi moshi) {
                if (Types.equals((Type)type, (Type)requestedType)) {
                    JsonAdapter delegate = moshi.nextAdapter((JsonAdapter.Factory)this, type, annotations);
                    return new DefaultOnDataMismatchAdapter<Object>(delegate, defaultValue);
                }
                return null;
            }
        };
    }
}

