/*
 * Decompiled with CFR 0.152.
 */
package com.serjltt.moshi.adapters;

import com.serjltt.moshi.adapters.FallbackEnumJsonAdapter;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.Set;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface FallbackEnum {
    public static final JsonAdapter.Factory ADAPTER_FACTORY = new JsonAdapter.Factory(){

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (!annotations.isEmpty()) {
                return null;
            }
            Class rawType = Types.getRawType((Type)type);
            if (rawType.isEnum()) {
                FallbackEnum annotation = rawType.getAnnotation(FallbackEnum.class);
                if (annotation == null) {
                    return null;
                }
                return new FallbackEnumJsonAdapter(rawType, annotation.name()).nullSafe();
            }
            return null;
        }
    };

    public String name();
}

