/*
 * Decompiled with CFR 0.152.
 */
package com.serjltt.moshi.adapters;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

final class FallbackOnNullJsonAdapter<T>
extends JsonAdapter<T> {
    static final Set<Class<?>> PRIMITIVE_CLASSES = new LinkedHashSet();
    final JsonAdapter<T> delegate;
    final T fallback;
    final String fallbackType;

    FallbackOnNullJsonAdapter(JsonAdapter<T> delegate, T fallback, String fallbackType) {
        this.delegate = delegate;
        this.fallback = fallback;
        this.fallbackType = fallbackType;
    }

    public T fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            reader.nextNull();
            return this.fallback;
        }
        return (T)this.delegate.fromJson(reader);
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        this.delegate.toJson(writer, value);
    }

    public String toString() {
        return this.delegate + ".fallbackOnNull(" + this.fallbackType + '=' + this.fallback + ')';
    }

    static {
        PRIMITIVE_CLASSES.add(Boolean.TYPE);
        PRIMITIVE_CLASSES.add(Byte.TYPE);
        PRIMITIVE_CLASSES.add(Character.TYPE);
        PRIMITIVE_CLASSES.add(Double.TYPE);
        PRIMITIVE_CLASSES.add(Float.TYPE);
        PRIMITIVE_CLASSES.add(Integer.TYPE);
        PRIMITIVE_CLASSES.add(Long.TYPE);
        PRIMITIVE_CLASSES.add(Short.TYPE);
    }
}

