/*
 * Decompiled with CFR 0.152.
 */
package com.serjltt.moshi.adapters;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

final class FilterNullsJsonAdapter<T>
extends JsonAdapter<T> {
    private final JsonAdapter<T> delegate;

    FilterNullsJsonAdapter(JsonAdapter<T> delegate) {
        this.delegate = delegate;
    }

    public T fromJson(JsonReader reader) throws IOException {
        return (T)this.removeNulls(this.delegate.fromJson(reader));
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        this.delegate.toJson(writer, this.removeNulls(value));
    }

    public String toString() {
        return this.delegate + ".filterNulls()";
    }

    private T removeNulls(T value) {
        if (value != null) {
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
        }
        return value;
    }
}

