/*
 * Decompiled with CFR 0.152.
 */
package com.serjltt.moshi.adapters;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;

final class TransientJsonAdapter<T>
extends JsonAdapter<T> {
    private final JsonAdapter<T> delegate;
    private final boolean serialize;
    private final boolean deserialize;

    TransientJsonAdapter(JsonAdapter<T> delegate, boolean serialize, boolean deserialize) {
        this.delegate = delegate;
        this.serialize = serialize;
        this.deserialize = deserialize;
    }

    public T fromJson(JsonReader reader) throws IOException {
        if (this.deserialize) {
            return (T)this.delegate.fromJson(reader);
        }
        reader.skipValue();
        return null;
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        if (this.serialize) {
            this.delegate.toJson(writer, value);
        } else {
            this.delegate.toJson(writer, null);
        }
    }

    public String toString() {
        return this.delegate + (this.serialize && this.deserialize ? "" : (this.serialize ? ".serializeOnly()" : (this.deserialize ? ".deserializeOnly()" : ".transient()")));
    }
}

