/*
 * Decompiled with CFR 0.152.
 */
package com.serjltt.moshi.adapters;

import com.serjltt.moshi.adapters.Pair;
import com.serjltt.moshi.adapters.Util;
import com.serjltt.moshi.adapters.WrappedJsonAdapter;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.Moshi;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;

@Documented
@JsonQualifier
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
public @interface Wrapped {
    public static final JsonAdapter.Factory ADAPTER_FACTORY = new JsonAdapter.Factory(){

        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            Pair<Wrapped, Set<Annotation>> nextAnnotations = Util.nextAnnotations(annotations, Wrapped.class);
            if (nextAnnotations == null) {
                return null;
            }
            JsonAdapter adapter = moshi.adapter(type, (Set)nextAnnotations.second);
            Wrapped wrapped = (Wrapped)nextAnnotations.first;
            return new WrappedJsonAdapter(adapter, wrapped.path(), wrapped.failOnNotFound());
        }
    };

    public String[] path();

    public boolean failOnNotFound() default true;

    public static final class Factory {
        public static Wrapped create(String ... path) {
            return Factory.create(true, path);
        }

        public static Wrapped create(final boolean failOnNotFound, final String ... path) {
            return new Wrapped(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Wrapped.class;
                }

                @Override
                public String[] path() {
                    return path;
                }

                @Override
                public boolean failOnNotFound() {
                    return failOnNotFound;
                }

                @Override
                public int hashCode() {
                    int result = Arrays.hashCode(path);
                    result = 43 * result + (failOnNotFound ? 1 : 0);
                    return result;
                }

                @Override
                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null || this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Wrapped wrapped = (Wrapped)obj;
                    return Arrays.equals(path, wrapped.path()) && failOnNotFound == wrapped.failOnNotFound();
                }

                @Override
                public String toString() {
                    return "Wrapped(path=" + Arrays.asList(path) + ", failOnNotFound=" + failOnNotFound + ")";
                }
            };
        }

        private Factory() {
            throw new AssertionError((Object)"No instances.");
        }
    }
}

