/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.Values;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class Scheme {
    @Nonnull
    public final String value;

    private Scheme(@Nonnull String value) {
        this.value = value;
    }

    public static Optional<Scheme> parseScheme(String value) {
        if (value.matches("^[a-zA-Z][a-zA-Z0-9+\\-.]*:$")) {
            return Optional.of(new Scheme(value.substring(0, value.length() - 1).toLowerCase(Locale.ENGLISH)));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.value + ":";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scheme scheme = (Scheme)o;
        return this.value.equals(scheme.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

