/*
 * Decompiled with CFR 0.152.
 */
package org.gm4java.engine.support;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.gm4java.engine.GMServiceException;
import org.gm4java.engine.support.GMConnectionPoolConfig;
import org.gm4java.engine.support.GMProcessFactory;
import org.gm4java.engine.support.GMProcessFactoryImpl;
import org.gm4java.engine.support.PooledGMConnection;
import org.gm4java.engine.support.ReaderWriterProcess;

class GMConnectionPool
extends GenericObjectPool<PooledGMConnection> {
    private GMProcessFactory.Builder builder;
    private GMProcessFactory gmFactory;
    private int evictAfterNumberOfUse = 0;

    GMConnectionPool(@Nonnull GMConnectionPoolConfig config) {
        this(new Factory(), config);
    }

    private GMConnectionPool(Factory factory, GMConnectionPoolConfig config) {
        super((PoolableObjectFactory)factory, GMConnectionPool.getParentConfig(config));
        factory.pool = this;
        this.evictAfterNumberOfUse = config.getEvictAfterNumberOfUse();
        this.builder = GMProcessFactoryImpl.BUILDER;
        this.gmFactory = this.builder.buildFactory(config.getGMPath());
    }

    private static GenericObjectPool.Config getParentConfig(GMConnectionPoolConfig config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        return config.getConfig();
    }

    @Nonnull
    public PooledGMConnection borrowObject() throws GMServiceException {
        try {
            return (PooledGMConnection)super.borrowObject();
        }
        catch (GMServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GMServiceException(e.getMessage(), e);
        }
    }

    public void returnObject(@Nonnull PooledGMConnection connection) throws GMServiceException {
        try {
            super.returnObject((Object)connection);
        }
        catch (GMServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GMServiceException(e.getMessage(), e);
        }
    }

    public String getGMPath() {
        return this.gmFactory.getGMPath();
    }

    public void setGMPath(@Nonnull String gmPath) {
        if (gmPath == null) {
            throw new NullPointerException("gmPath");
        }
        this.gmFactory = this.builder.buildFactory(gmPath);
    }

    public int getEvictAfterNumberOfUse() {
        return this.evictAfterNumberOfUse;
    }

    public void setEvictAfterNumberOfUse(int evictAfterNumberOfUse) {
        this.evictAfterNumberOfUse = evictAfterNumberOfUse;
    }

    void setProcessFactoryBuilder(GMProcessFactory.Builder builder) {
        this.builder = builder;
        this.gmFactory = builder.buildFactory(this.gmFactory.getGMPath());
    }

    ReaderWriterProcess createProcess() throws GMServiceException {
        try {
            return this.gmFactory.getProcess();
        }
        catch (IOException e) {
            throw new GMServiceException(e.getMessage(), e);
        }
    }

    private static final class Factory
    extends BasePoolableObjectFactory<PooledGMConnection> {
        private GMConnectionPool pool;

        private Factory() {
        }

        public PooledGMConnection makeObject() throws GMServiceException {
            return new PooledGMConnection(this.pool);
        }

        public void destroyObject(PooledGMConnection connection) throws GMServiceException {
            connection.close();
        }

        public boolean validateObject(PooledGMConnection connection) {
            try {
                connection.execute("ping", new String[0]);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public void activateObject(PooledGMConnection connection) throws GMServiceException {
            connection.ensureHealthy();
        }

        public void passivateObject(PooledGMConnection connection) throws GMServiceException {
            connection.ensureHealthy();
        }
    }
}

