/*
 * Decompiled with CFR 0.152.
 */
package org.gm4java.engine.support;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.gm4java.engine.GMException;
import org.gm4java.engine.GMServiceException;
import org.gm4java.engine.support.BasicGMConnection;
import org.gm4java.engine.support.GMConnectionPool;

class PooledGMConnection
extends BasicGMConnection {
    private final GMConnectionPool pool;
    private int count;
    private Throwable exception;

    PooledGMConnection(@Nonnull GMConnectionPool pool) throws GMServiceException {
        super(PooledGMConnection.notNull(pool).createProcess());
        this.pool = pool;
    }

    @Override
    protected String execute(String command, @Nonnull List<String> arguments) throws IOException, GMException, GMServiceException {
        ++this.count;
        try {
            return super.execute(command, arguments);
        }
        catch (IOException e) {
            throw e;
        }
        catch (GMException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.exception = e;
            throw e;
        }
        catch (GMServiceException e) {
            this.exception = e;
            throw e;
        }
        catch (Error e) {
            this.exception = e;
            throw e;
        }
    }

    void ensureHealthy() throws GMServiceException {
        if (this.exception != null) {
            throw new GMServiceException(this.exception.getMessage(), this.exception);
        }
        int limit = this.pool.getEvictAfterNumberOfUse();
        if (limit > 0 && this.count > limit) {
            throw new GMServiceException(String.format("Instance is stale, executed %d commands which exceeded the %d limit.", this.count, limit));
        }
    }

    private static GMConnectionPool notNull(GMConnectionPool pool) {
        if (pool == null) {
            throw new NullPointerException("pool");
        }
        return pool;
    }
}

