/*
 * Decompiled with CFR 0.152.
 */
package org.gm4java.engine.support;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.gm4java.engine.GMConnection;
import org.gm4java.engine.GMException;
import org.gm4java.engine.GMService;
import org.gm4java.engine.GMServiceException;
import org.gm4java.engine.support.GMConnectionPool;
import org.gm4java.engine.support.GMConnectionPoolConfig;
import org.gm4java.engine.support.GMProcessFactory;
import org.gm4java.engine.support.PooledGMConnection;

public class PooledGMService
implements GMService {
    private final GMConnectionPool pool;

    public PooledGMService(@Nonnull GMConnectionPoolConfig config) {
        this.pool = new GMConnectionPool(config);
    }

    PooledGMService(GMConnectionPool pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(@Nonnull String command, String ... arguments) throws IOException, GMException, GMServiceException {
        PooledGMConnection connection = this.pool.borrowObject();
        try {
            String string = connection.execute(command, arguments);
            return string;
        }
        finally {
            this.pool.returnObject(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(List<String> command) throws IOException, GMException, GMServiceException {
        PooledGMConnection connection = this.pool.borrowObject();
        try {
            String string = connection.execute(command);
            return string;
        }
        finally {
            this.pool.returnObject(connection);
        }
    }

    @Override
    @Nonnull
    public GMConnection getConnection() throws GMServiceException {
        return new ConnectionWrapper(this.pool);
    }

    void setProcessFactoryBuilder(GMProcessFactory.Builder builder) {
        this.pool.setProcessFactoryBuilder(builder);
    }

    private static final class ConnectionWrapper
    implements GMConnection {
        @Nonnull
        private final GMConnectionPool pool;
        private PooledGMConnection real;

        private ConnectionWrapper(GMConnectionPool pool) throws GMServiceException {
            this.pool = pool;
            this.real = pool.borrowObject();
        }

        @Override
        public String execute(@Nonnull String command, String ... arguments) throws IOException, GMException, GMServiceException {
            this.assertConnectionNotClosed();
            return this.real.execute(command, arguments);
        }

        @Override
        public String execute(List<String> command) throws IOException, GMException, GMServiceException {
            this.assertConnectionNotClosed();
            return this.real.execute(command);
        }

        @Override
        public void close() throws GMServiceException {
            if (this.real == null) {
                return;
            }
            this.pool.returnObject(this.real);
            this.real = null;
        }

        private void assertConnectionNotClosed() throws GMServiceException {
            if (this.real == null) {
                throw new GMServiceException("GMConnection is already closed.");
            }
        }
    }
}

