/*
 * Decompiled with CFR 0.152.
 */
package org.gm4java.engine.support;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import org.gm4java.engine.support.ReaderWriterProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReaderWriterProcessImpl
implements ReaderWriterProcess {
    public static final ReaderWriterProcess.Factory FACTORY = new ReaderWriterProcess.Factory(){

        @Override
        @Nonnull
        public ReaderWriterProcess getProcess(String ... command) throws IOException {
            return new ReaderWriterProcessImpl(command);
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(ReaderWriterProcessImpl.class);
    private final Process process;
    private final OutputStream outputStream;
    private final InputStream inputStream;
    private final BufferedReader reader;
    private final Writer writer;

    public ReaderWriterProcessImpl(String ... command) throws IOException {
        if (command == null) {
            throw new NullPointerException("command");
        }
        this.process = new ProcessBuilder(new String[0]).command(command).redirectErrorStream(true).start();
        this.outputStream = this.process.getOutputStream();
        this.inputStream = this.process.getInputStream();
        this.writer = new OutputStreamWriter(this.outputStream);
        this.reader = new BufferedReader(new InputStreamReader(this.inputStream));
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public BufferedReader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            this.quietlyClose(this.outputStream);
            this.quietlyClose(this.inputStream);
        }
        finally {
            this.process.destroy();
        }
    }

    private void quietlyClose(Closeable c) {
        try {
            c.close();
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }
}

