/*
 * Decompiled with CFR 0.152.
 */
package org.gm4java.engine.support;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.gm4java.engine.GMConnection;
import org.gm4java.engine.GMException;
import org.gm4java.engine.GMService;
import org.gm4java.engine.GMServiceException;
import org.gm4java.engine.support.BasicGMConnection;
import org.gm4java.engine.support.GMProcessFactory;
import org.gm4java.engine.support.GMProcessFactoryImpl;

public class SimpleGMService
implements GMService {
    public static final String DEFAULT_GM_PATH = "gm";
    private final GMProcessFactory.Builder builder;
    private GMProcessFactory factory;

    public SimpleGMService() {
        this(GMProcessFactoryImpl.BUILDER);
    }

    SimpleGMService(GMProcessFactory.Builder builder) {
        this.builder = builder;
        this.factory = builder.buildFactory(DEFAULT_GM_PATH);
    }

    @Nonnull
    public String getGMPath() {
        return this.factory.getGMPath();
    }

    public void setGMPath(@Nonnull String gmPath) {
        if (gmPath == null) {
            throw new NullPointerException("gmPath");
        }
        this.factory = this.builder.buildFactory(gmPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(@Nonnull String command, String ... arguments) throws GMException, GMServiceException, IOException {
        GMConnection connection = this.getConnection();
        try {
            String string = connection.execute(command, arguments);
            return string;
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(List<String> command) throws GMException, GMServiceException, IOException {
        GMConnection connection = this.getConnection();
        try {
            String string = connection.execute(command);
            return string;
        }
        finally {
            connection.close();
        }
    }

    @Override
    @Nonnull
    public GMConnection getConnection() throws GMServiceException {
        try {
            return new BasicGMConnection(this.factory.getProcess());
        }
        catch (IOException e) {
            throw new GMServiceException(e.getMessage(), e);
        }
    }
}

