/*
 * Decompiled with CFR 0.152.
 */
package org.gm4java.im4java;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import org.gm4java.engine.GMException;
import org.gm4java.engine.GMExecutor;
import org.im4java.core.ImageCommand;
import org.im4java.process.ErrorConsumer;
import org.im4java.process.OutputConsumer;

public class GMBatchCommand
extends ImageCommand {
    private final GMExecutor executor;
    private OutputConsumer outputConsumer;
    private ErrorConsumer errorConsumer;

    public GMBatchCommand(@Nonnull GMExecutor executor, @Nonnull String command) {
        super(new String[]{command});
        this.executor = executor;
    }

    public void setOutputConsumer(@Nonnull OutputConsumer pOutputConsumer) {
        super.setOutputConsumer(pOutputConsumer);
        this.outputConsumer = pOutputConsumer;
    }

    public void setErrorConsumer(@Nonnull ErrorConsumer pErrorConsumer) {
        super.setErrorConsumer(pErrorConsumer);
        this.errorConsumer = pErrorConsumer;
    }

    protected int run(@Nonnull LinkedList<String> pArgs) throws Exception {
        int rc;
        try {
            String result = this.executor.execute(pArgs);
            if (this.outputConsumer != null && result != null) {
                this.outputConsumer.consumeOutput(this.stringToStream(result));
            }
            rc = 0;
        }
        catch (GMException e) {
            if (this.errorConsumer == null) {
                throw e;
            }
            this.errorConsumer.consumeError(this.stringToStream(e.getMessage()));
            rc = 1;
        }
        this.finished(rc);
        return rc;
    }

    @Deprecated
    public void setSearchPath(String pSearchPath) {
        throw new UnsupportedOperationException("GMBatchCommand does not support setSearchPath because it uses the GMExecutor passed to the constructor instead of starting a GraphicsMagick process itself.");
    }

    @Nonnull
    private InputStream stringToStream(@Nonnull String s) {
        return new ByteArrayInputStream(s.getBytes());
    }
}

