/*
 * Decompiled with CFR 0.152.
 */
package com.shazam.axmlparser;

import com.google.common.io.LittleEndianDataInputStream;
import com.shazam.axmlparser.ExtDataInput;
import com.shazam.axmlparser.ReadUtil;
import com.shazam.axmlparser.StringBlock;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;

public final class AXMLParser {
    public static final int START_DOCUMENT = 0;
    public static final int END_DOCUMENT = 1;
    public static final int START_TAG = 2;
    public static final int END_TAG = 3;
    public static final int TEXT = 4;
    private InputStream m_stream;
    private StringBlock m_strings;
    private int[] m_resourceIDs;
    private IOException m_nextException;
    private int m_tagType;
    private int m_tagSourceLine;
    private int m_tagName;
    private TagAttribute[] m_tagAttributes;
    private static final int AXML_CHUNK_TYPE = 524291;
    private static final int RESOURCEIDS_CHUNK_TYPE = 524672;

    public AXMLParser(InputStream stream) throws IOException {
        this.m_stream = stream;
        this.doStart();
    }

    public final void close() {
        if (this.m_stream == null) {
            return;
        }
        try {
            this.m_stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.m_nextException == null) {
            this.m_nextException = new IOException("Closed.");
        }
        this.m_stream = null;
        this.resetState();
    }

    public final int next() throws IOException {
        if (this.m_nextException != null) {
            throw this.m_nextException;
        }
        try {
            return this.doNext();
        }
        catch (IOException e) {
            this.m_nextException = e;
            this.resetState();
            throw e;
        }
    }

    public final int getType() {
        return this.m_tagType;
    }

    public final String getName() {
        if (this.m_tagName == -1) {
            return null;
        }
        return this.getString(this.m_tagName);
    }

    public final int getLineNumber() {
        return this.m_tagSourceLine;
    }

    public final int getAttributeCount() {
        if (this.m_tagAttributes == null) {
            return -1;
        }
        return this.m_tagAttributes.length;
    }

    public final String getAttributeNamespace(int index) {
        return this.getString(this.getAttribute((int)index).namespace);
    }

    public final String getAttributeName(int index) {
        return this.getString(this.getAttribute((int)index).name);
    }

    public final int getAttributeResourceID(int index) {
        int resourceIndex = this.getAttribute((int)index).name;
        if (this.m_resourceIDs == null || resourceIndex < 0 || resourceIndex >= this.m_resourceIDs.length) {
            return 0;
        }
        return this.m_resourceIDs[resourceIndex];
    }

    public final int getAttributeValueType(int index) {
        return this.getAttribute((int)index).valueType;
    }

    public final String getAttributeValueString(int index) {
        return this.getString(this.getAttribute((int)index).valueString);
    }

    public final int getAttributeValue(int index) {
        return this.getAttribute((int)index).value;
    }

    private final void resetState() {
        this.m_tagType = -1;
        this.m_tagSourceLine = -1;
        this.m_tagName = -1;
        this.m_tagAttributes = null;
    }

    private final void doStart() throws IOException {
        ReadUtil.readCheckType(this.m_stream, 524291);
        ReadUtil.readInt(this.m_stream);
        this.m_strings = StringBlock.read(new ExtDataInput((DataInput)new LittleEndianDataInputStream(this.m_stream)));
        ReadUtil.readCheckType(this.m_stream, 524672);
        int chunkSize = ReadUtil.readInt(this.m_stream);
        if (chunkSize < 8 || chunkSize % 4 != 0) {
            throw new IOException("Invalid resource ids size (" + chunkSize + ").");
        }
        this.m_resourceIDs = ReadUtil.readIntArray(this.m_stream, chunkSize / 4 - 2);
        this.resetState();
    }

    private final int doNext() throws IOException {
        if (this.m_tagType == 1) {
            return 1;
        }
        this.m_tagType = ReadUtil.readInt(this.m_stream) & 0xFF;
        ReadUtil.readInt(this.m_stream);
        this.m_tagSourceLine = ReadUtil.readInt(this.m_stream);
        ReadUtil.readInt(this.m_stream);
        this.m_tagName = -1;
        this.m_tagAttributes = null;
        switch (this.m_tagType) {
            case 0: {
                ReadUtil.readInt(this.m_stream);
                ReadUtil.readInt(this.m_stream);
                break;
            }
            case 2: {
                ReadUtil.readInt(this.m_stream);
                this.m_tagName = ReadUtil.readInt(this.m_stream);
                ReadUtil.readInt(this.m_stream);
                int attributeCount = ReadUtil.readInt(this.m_stream);
                ReadUtil.readInt(this.m_stream);
                this.m_tagAttributes = new TagAttribute[attributeCount];
                for (int i = 0; i != attributeCount; ++i) {
                    TagAttribute attribute = new TagAttribute();
                    attribute.namespace = ReadUtil.readInt(this.m_stream);
                    attribute.name = ReadUtil.readInt(this.m_stream);
                    attribute.valueString = ReadUtil.readInt(this.m_stream);
                    attribute.valueType = ReadUtil.readInt(this.m_stream) >>> 24;
                    attribute.value = ReadUtil.readInt(this.m_stream);
                    this.m_tagAttributes[i] = attribute;
                }
                break;
            }
            case 3: {
                ReadUtil.readInt(this.m_stream);
                this.m_tagName = ReadUtil.readInt(this.m_stream);
                break;
            }
            case 4: {
                this.m_tagName = ReadUtil.readInt(this.m_stream);
                ReadUtil.readInt(this.m_stream);
                ReadUtil.readInt(this.m_stream);
                break;
            }
            case 1: {
                ReadUtil.readInt(this.m_stream);
                ReadUtil.readInt(this.m_stream);
                break;
            }
            default: {
                throw new IOException("Invalid tag type (" + this.m_tagType + ").");
            }
        }
        return this.m_tagType;
    }

    private final TagAttribute getAttribute(int index) {
        if (this.m_tagAttributes == null) {
            throw new IndexOutOfBoundsException("Attributes are not available.");
        }
        if (index >= this.m_tagAttributes.length) {
            throw new IndexOutOfBoundsException("Invalid attribute index (" + index + ").");
        }
        return this.m_tagAttributes[index];
    }

    private final String getString(int index) {
        if (index == -1) {
            return "";
        }
        return this.m_strings.getString(index);
    }

    private static final class TagAttribute {
        public int namespace;
        public int name;
        public int valueString;
        public int valueType;
        public int value;

        private TagAttribute() {
        }
    }
}

