/*
 * Decompiled with CFR 0.152.
 */
package com.shedhack.trace.request.api.model;

import com.shedhack.trace.request.api.constant.Status;
import com.shedhack.trace.request.api.model.RequestModel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DefaultRequestModel
implements RequestModel,
Serializable {
    private String spanId;
    private String applicationId;
    private String traceId;
    private String callerId;
    private String path;
    private String sessionId;
    private String httpMethod;
    private String clientAddress;
    private String hostAddress;
    private Map<String, String> headers;
    private String exceptionId;
    private long requestDateTime;
    private long responseDateTime;
    private Status status;
    private int httpStatusCode;

    public static Builder builder(String applicationId, String spanId, String traceId) {
        return new Builder(applicationId, spanId, traceId);
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public String getSpanId() {
        return this.spanId;
    }

    @Override
    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    @Override
    public String getTraceId() {
        return this.traceId;
    }

    @Override
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Override
    public String getCallerId() {
        return this.callerId;
    }

    @Override
    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public String getClientAddress() {
        return this.clientAddress;
    }

    @Override
    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    @Override
    public String getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    @Override
    public long getRequestDateTime() {
        return this.requestDateTime;
    }

    @Override
    public void setRequestDateTime(long requestDateTime) {
        this.requestDateTime = requestDateTime;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public long getResponseDateTime() {
        return this.responseDateTime;
    }

    @Override
    public void setResponseDateTime(long responseDateTime) {
        this.responseDateTime = responseDateTime;
    }

    @Override
    public String getExceptionId() {
        return this.exceptionId;
    }

    @Override
    public void setExceptionId(String exceptionId) {
        this.exceptionId = exceptionId;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Override
    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRequestModel that = (DefaultRequestModel)o;
        if (this.requestDateTime != that.requestDateTime) {
            return false;
        }
        if (this.responseDateTime != that.responseDateTime) {
            return false;
        }
        if (this.httpStatusCode != that.httpStatusCode) {
            return false;
        }
        if (this.spanId != null ? !this.spanId.equals(that.spanId) : that.spanId != null) {
            return false;
        }
        if (this.applicationId != null ? !this.applicationId.equals(that.applicationId) : that.applicationId != null) {
            return false;
        }
        if (this.traceId != null ? !this.traceId.equals(that.traceId) : that.traceId != null) {
            return false;
        }
        if (this.callerId != null ? !this.callerId.equals(that.callerId) : that.callerId != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.sessionId != null ? !this.sessionId.equals(that.sessionId) : that.sessionId != null) {
            return false;
        }
        if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) {
            return false;
        }
        if (this.clientAddress != null ? !this.clientAddress.equals(that.clientAddress) : that.clientAddress != null) {
            return false;
        }
        if (this.hostAddress != null ? !this.hostAddress.equals(that.hostAddress) : that.hostAddress != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.exceptionId != null ? !this.exceptionId.equals(that.exceptionId) : that.exceptionId != null) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = this.spanId != null ? this.spanId.hashCode() : 0;
        result = 31 * result + (this.applicationId != null ? this.applicationId.hashCode() : 0);
        result = 31 * result + (this.traceId != null ? this.traceId.hashCode() : 0);
        result = 31 * result + (this.callerId != null ? this.callerId.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.sessionId != null ? this.sessionId.hashCode() : 0);
        result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
        result = 31 * result + (this.clientAddress != null ? this.clientAddress.hashCode() : 0);
        result = 31 * result + (this.hostAddress != null ? this.hostAddress.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.exceptionId != null ? this.exceptionId.hashCode() : 0);
        result = 31 * result + (int)(this.requestDateTime ^ this.requestDateTime >>> 32);
        result = 31 * result + (int)(this.responseDateTime ^ this.responseDateTime >>> 32);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + this.httpStatusCode;
        return result;
    }

    public String toString() {
        return "{\"DefaultRequestModel\":{\"spanId\":\"" + this.spanId + "\"" + ", \"applicationId\":\"" + this.applicationId + "\"" + ", \"traceId\":\"" + this.traceId + "\"" + ", \"callerId\":\"" + this.callerId + "\"" + ", \"path\":\"" + this.path + "\"" + ", \"sessionId\":\"" + this.sessionId + "\"" + ", \"httpMethod\":\"" + this.httpMethod + "\"" + ", \"clientAddress\":\"" + this.clientAddress + "\"" + ", \"hostAddress\":\"" + this.hostAddress + "\"" + ", \"headers\":\"" + this.headers + "\"" + ", \"exceptionId\":\"" + this.exceptionId + "\"" + ", \"requestDateTime\":\"" + this.requestDateTime + "\"" + ", \"responseDateTime\":\"" + this.responseDateTime + "\"" + ", \"status\":\"" + (Object)((Object)this.status) + "\"" + ", \"httpStatusCode\":\"" + this.httpStatusCode + "\"" + "}}";
    }

    public static class Builder {
        DefaultRequestModel model = new DefaultRequestModel();

        public Builder(String appId, String spanId, String traceId) {
            this.withApplicationId(appId).withSpanId(spanId).withTraceId(traceId);
        }

        private Builder withApplicationId(String id) {
            this.model.applicationId = id;
            return this;
        }

        public Builder withRequestDateTime(long date) {
            this.model.requestDateTime = date;
            return this;
        }

        private Builder withSpanId(String spanId) {
            this.model.spanId = spanId;
            return this;
        }

        private Builder withTraceId(String traceId) {
            this.model.traceId = traceId;
            return this;
        }

        public Builder withCallerId(String callerId) {
            this.model.callerId = callerId;
            return this;
        }

        public Builder withPath(String path) {
            this.model.path = path;
            return this;
        }

        public Builder withSessionId(String sessionId) {
            this.model.sessionId = sessionId;
            return this;
        }

        public Builder withHttpMethod(String method) {
            this.model.httpMethod = method;
            return this;
        }

        public Builder withClientAddress(String address) {
            this.model.clientAddress = address;
            return this;
        }

        public Builder withHostAddress(String address) {
            this.model.hostAddress = address;
            return this;
        }

        public Builder withHttpHeaders(Map<String, String> headers) {
            if (this.model.headers == null) {
                this.model.headers = new HashMap();
            }
            this.model.headers = headers;
            return this;
        }

        public Builder withHttpHeader(String key, String value) {
            if (this.model.headers == null) {
                this.model.headers = new HashMap();
            }
            this.model.headers.put(key, value);
            return this;
        }

        public Builder withExceptionId(String exceptionId) {
            this.model.exceptionId = exceptionId;
            return this;
        }

        public Builder withStatus(Status status) {
            this.model.status = status;
            return this;
        }

        public Builder withResponseDateTime(long date) {
            this.model.responseDateTime = date;
            return this;
        }

        public Builder withHttpStatusCode(int code) {
            this.model.httpStatusCode = code;
            return this;
        }

        public DefaultRequestModel build() {
            return this.model;
        }
    }
}

