/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.juds;

import com.oscar.Driver;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;

public abstract class UnixDomainSocket {
    public static final int SOCK_DGRAM = 0;
    public static final int SOCK_STREAM = 1;
    protected UnixDomainSocketInputStream in;
    protected UnixDomainSocketOutputStream out;
    protected int nativeSocketFileHandle;
    protected String socketFile;
    protected int socketType;
    private int timeout;

    protected static native int nativeCreate(String var0, int var1);

    protected static native int nativeListen(String var0, int var1, int var2);

    protected static native int nativeAccept(int var0, int var1);

    protected static native int nativeOpen(String var0, int var1);

    protected static native int nativeRead(int var0, byte[] var1, int var2, int var3);

    protected static native int nativeWrite(int var0, byte[] var1, int var2, int var3);

    protected static native int nativeClose(int var0);

    protected static native int nativeCloseInput(int var0);

    protected static native int nativeCloseOutput(int var0);

    protected static native int nativeUnlink(String var0);

    protected UnixDomainSocket() {
    }

    protected UnixDomainSocket(int n2, int n3) throws IOException {
        this.nativeSocketFileHandle = n2;
        this.socketType = n3;
        this.socketFile = null;
        this.in = new UnixDomainSocketInputStream();
        if (this.socketType == 1) {
            this.out = new UnixDomainSocketOutputStream();
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setTimeout(int n2) {
        this.timeout = n2;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void close() {
        UnixDomainSocket.nativeClose(this.nativeSocketFileHandle);
    }

    public void unlink() {
        if (this.socketFile != null) {
            UnixDomainSocket.nativeUnlink(this.socketFile);
        }
    }

    public static void copySo(String string, String object) throws IOException {
        FilterOutputStream filterOutputStream;
        block18: {
            InputStream inputStream = null;
            filterOutputStream = null;
            try {
                object = new File((String)object);
                if (!((File)object).exists()) {
                    Object object2;
                    Object object3;
                    if ("loongarch64".equals(string)) {
                        Object object4;
                        object3 = null;
                        try {
                            object4 = new ProcessBuilder("getconf", "GNU_LIBC_VERSION");
                            object2 = ((ProcessBuilder)object4).start();
                            object3 = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream()));
                            while ((object4 = ((BufferedReader)object3).readLine()) != null) {
                                if (!((String)(object4 = ((String)object4).toLowerCase())).startsWith("glibc")) continue;
                                string = ((BigDecimal)(object4 = new BigDecimal(((String)object4).replaceAll("glibc", "").trim()))).compareTo(new BigDecimal("2.36")) < 0 ? "loongarch64" : "loongarchn64";
                                break;
                            }
                            ((Process)object2).waitFor();
                            ((BufferedReader)object3).close();
                        }
                        catch (Exception exception) {
                            object4 = exception;
                            exception.printStackTrace();
                        }
                        finally {
                            if (object3 != null) {
                                ((BufferedReader)object3).close();
                            }
                        }
                    }
                    if ((inputStream = UnixDomainSocket.class.getResourceAsStream((String)(object3 = "/com/google/code/juds/" + string + "/libunixdomainsocket.so"))) != null) {
                        int n2;
                        filterOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
                        object2 = new byte[10240];
                        while ((n2 = inputStream.read((byte[])object2)) != -1) {
                            ((BufferedOutputStream)filterOutputStream).write((byte[])object2, 0, n2);
                        }
                        ((BufferedOutputStream)filterOutputStream).flush();
                    }
                } else {
                    Driver.writeLog("file exists" + ((File)object).getAbsolutePath());
                }
                if (inputStream == null) break block18;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        if (filterOutputStream != null) {
            filterOutputStream.close();
            return;
        }
    }

    static {
        Object object = UnixDomainSocket.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            String string;
            object = new URI(((URL)object).getProtocol(), ((URL)object).getHost(), ((URL)object).getPath(), ((URL)object).getQuery(), null).getPath();
            if (object != null) {
                if (((String)object).endsWith("/") || ((String)object).endsWith("\\")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                if (((String)object).endsWith(".jar")) {
                    int n2 = ((String)object).lastIndexOf("/");
                    if (n2 != -1) {
                        object = ((String)object).substring(0, n2);
                    }
                    object = (String)object + File.separator + "libunixdomainsocket.so";
                } else {
                    object = (String)object + File.separator + ".." + File.separator + "libunixdomainsocket.so";
                }
            }
            if ("aarch64".equals(string = System.getProperty("os.arch")) || "mips64el".equals(string) || "sw64".equals(string) || "i386".equals(string) || "amd64".equals(string) || "loongarch64".equals(string)) {
                UnixDomainSocket.copySo(string, (String)object);
            } else {
                Driver.writeLog("arch not support:" + string);
            }
            if (object != null) {
                System.load((String)object);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            Driver.writeLog(exception);
            System.loadLibrary("unixdomainsocket");
        }
    }

    protected class UnixDomainSocketReadThread
    extends Thread {
        private int count;
        private int off;
        private int len;
        private byte[] b;

        public UnixDomainSocketReadThread(byte[] byArray, int n2, int n3) {
            this.b = byArray;
            this.off = n2;
            this.len = n3;
        }

        @Override
        public void run() {
            this.count = UnixDomainSocket.nativeRead(UnixDomainSocket.this.nativeSocketFileHandle, this.b, this.off, this.len);
        }

        public int getData() {
            return this.count;
        }
    }

    protected class UnixDomainSocketOutputStream
    extends OutputStream {
        protected UnixDomainSocketOutputStream() {
        }

        @Override
        public void write(int n2) throws IOException {
            byte[] byArray = new byte[1];
            byte[] byArray2 = byArray;
            byArray[0] = (byte)n2;
            if (UnixDomainSocket.nativeWrite(UnixDomainSocket.this.nativeSocketFileHandle, byArray2, 0, 1) != 1) {
                throw new IOException("Unable to write to Unix domain socket");
            }
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return;
            }
            if (UnixDomainSocket.nativeWrite(UnixDomainSocket.this.nativeSocketFileHandle, byArray, n2, n3) != n3) {
                throw new IOException("Unable to write to Unix domain socket");
            }
        }

        @Override
        public void close() throws IOException {
            UnixDomainSocket.nativeCloseOutput(UnixDomainSocket.this.nativeSocketFileHandle);
        }
    }

    protected class UnixDomainSocketInputStream
    extends InputStream {
        protected UnixDomainSocketInputStream() {
        }

        @Override
        public int read() throws IOException {
            int n2;
            byte[] byArray = new byte[1];
            if (UnixDomainSocket.this.timeout > 0) {
                UnixDomainSocketReadThread unixDomainSocketReadThread = new UnixDomainSocketReadThread(byArray, 0, 1);
                unixDomainSocketReadThread.setDaemon(true);
                unixDomainSocketReadThread.start();
                try {
                    unixDomainSocketReadThread.join(UnixDomainSocket.this.timeout);
                }
                catch (InterruptedException interruptedException) {}
                if (unixDomainSocketReadThread.isAlive()) {
                    throw new InterruptedIOException("Unix domain socket read() call timed out");
                }
                n2 = unixDomainSocketReadThread.getData();
            } else {
                n2 = UnixDomainSocket.nativeRead(UnixDomainSocket.this.nativeSocketFileHandle, byArray, 0, 1);
                if (n2 == -1) {
                    throw new IOException();
                }
            }
            if (n2 > 0) {
                return byArray[0];
            }
            return -1;
        }

        @Override
        public int read(byte[] object, int n2, int n3) throws IOException {
            int n4;
            if (object == null) {
                throw new NullPointerException();
            }
            if (n2 < 0 || n3 < 0 || n3 > ((byte[])object).length - n2) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            if (UnixDomainSocket.this.timeout > 0) {
                UnixDomainSocketReadThread unixDomainSocketReadThread = new UnixDomainSocketReadThread((byte[])object, n2, n3);
                object = unixDomainSocketReadThread;
                unixDomainSocketReadThread.setDaemon(true);
                ((Thread)object).start();
                try {
                    ((Thread)object).join(UnixDomainSocket.this.timeout);
                }
                catch (InterruptedException interruptedException) {}
                if (((Thread)object).isAlive()) {
                    throw new InterruptedIOException("Unix domain socket read() call timed out");
                }
                n4 = ((UnixDomainSocketReadThread)object).getData();
            } else {
                n4 = UnixDomainSocket.nativeRead(UnixDomainSocket.this.nativeSocketFileHandle, (byte[])object, n2, n3);
                if (n4 == -1) {
                    throw new IOException();
                }
            }
            return n4;
        }

        @Override
        public void close() throws IOException {
            UnixDomainSocket.nativeCloseInput(UnixDomainSocket.this.nativeSocketFileHandle);
        }
    }
}

