/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.juds;

import com.google.code.juds.UnixDomainSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UnixDomainSocketServer
extends UnixDomainSocket {
    public UnixDomainSocketServer(String string, int n2) throws IOException {
        this.socketFile = string;
        this.socketType = n2;
        this.nativeSocketFileHandle = UnixDomainSocketServer.nativeCreate(string, n2);
        if (this.nativeSocketFileHandle == -1) {
            throw new IOException("Unable to open Unix domain socket");
        }
        this.in = new UnixDomainSocket.UnixDomainSocketInputStream();
        if (n2 == 1) {
            this.out = new UnixDomainSocket.UnixDomainSocketOutputStream();
        }
    }

    public UnixDomainSocketServer(String string, int n2, int n3) throws IOException {
        this.socketFile = string;
        this.socketType = n2;
        this.nativeSocketFileHandle = UnixDomainSocketServer.nativeListen(this.socketFile, this.socketType, n3);
        if (this.nativeSocketFileHandle == -1) {
            throw new IOException("Unable to open and listen on Unix domain socket");
        }
    }

    public UnixDomainSocket accept() throws IOException {
        int n2 = UnixDomainSocketServer.nativeAccept(this.nativeSocketFileHandle, this.socketType);
        if (n2 == -1) {
            throw new IOException("Unable to accept on Unix domain socket");
        }
        return new UnixDomainSocket(n2, this.socketType){};
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.out == null) {
            throw new UnsupportedOperationException();
        }
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        if (this.in == null) {
            throw new UnsupportedOperationException();
        }
        return this.in;
    }
}

