/*
 * Decompiled with CFR 0.152.
 */
package com.org.bouncycastle.crypto.digests;

import com.org.bouncycastle.crypto.CryptoServiceProperties;
import com.org.bouncycastle.crypto.CryptoServicePurpose;
import com.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.org.bouncycastle.crypto.digests.GeneralDigest;
import com.org.bouncycastle.crypto.digests.Utils;
import com.org.bouncycastle.util.Memoable;
import com.org.bouncycastle.util.Pack;

public class SM3Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 32;
    private static final int BLOCK_SIZE = 16;
    private int[] V = new int[8];
    private int[] inwords = new int[16];
    private int xOff;
    private int[] W = new int[68];
    private static final int[] T;

    public SM3Digest() {
        this(CryptoServicePurpose.ANY);
    }

    public SM3Digest(CryptoServicePurpose cryptoServicePurpose) {
        super(cryptoServicePurpose);
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        ((GeneralDigest)this).reset();
    }

    public SM3Digest(SM3Digest sM3Digest) {
        super(sM3Digest);
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
        this.copyIn(sM3Digest);
    }

    private void copyIn(SM3Digest sM3Digest) {
        System.arraycopy(sM3Digest.V, 0, this.V, 0, this.V.length);
        System.arraycopy(sM3Digest.inwords, 0, this.inwords, 0, this.inwords.length);
        this.xOff = sM3Digest.xOff;
    }

    @Override
    public String getAlgorithmName() {
        return "SM3";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public Memoable copy() {
        return new SM3Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        memoable = (SM3Digest)memoable;
        super.copyIn((GeneralDigest)memoable);
        this.copyIn((SM3Digest)memoable);
    }

    @Override
    public void reset() {
        super.reset();
        this.V[0] = 1937774191;
        this.V[1] = 1226093241;
        this.V[2] = 388252375;
        this.V[3] = -628488704;
        this.V[4] = -1452330820;
        this.V[5] = 372324522;
        this.V[6] = -477237683;
        this.V[7] = -1325724082;
        this.xOff = 0;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        this.finish();
        Pack.intToBigEndian(this.V, byArray, n2);
        ((GeneralDigest)this).reset();
        return 32;
    }

    @Override
    protected void processWord(byte[] byArray, int n2) {
        this.inwords[this.xOff++] = Pack.bigEndianToInt(byArray, n2);
        if (this.xOff >= 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long l2) {
        if (this.xOff > 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
            this.processBlock();
        }
        while (this.xOff < 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
        }
        this.inwords[this.xOff++] = (int)(l2 >>> 32);
        this.inwords[this.xOff++] = (int)l2;
    }

    private int P0(int n2) {
        int n3 = n2 << 9 | n2 >>> 23;
        int n4 = n2 << 17 | n2 >>> 15;
        return n2 ^ n3 ^ n4;
    }

    private int P1(int n2) {
        int n3 = n2 << 15 | n2 >>> 17;
        int n4 = n2 << 23 | n2 >>> 9;
        return n2 ^ n3 ^ n4;
    }

    private int FF0(int n2, int n3, int n4) {
        return n2 ^ n3 ^ n4;
    }

    private int FF1(int n2, int n3, int n4) {
        return n2 & n3 | n2 & n4 | n3 & n4;
    }

    private int GG0(int n2, int n3, int n4) {
        return n2 ^ n3 ^ n4;
    }

    private int GG1(int n2, int n3, int n4) {
        return n2 & n3 | ~n2 & n4;
    }

    @Override
    protected void processBlock() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        for (n11 = 0; n11 < 16; ++n11) {
            this.W[n11] = this.inwords[n11];
        }
        for (n11 = 16; n11 < 68; ++n11) {
            n10 = this.W[n11 - 3];
            n9 = n10 << 15 | n10 >>> 17;
            n8 = this.W[n11 - 13];
            n7 = n8 << 7 | n8 >>> 25;
            SM3Digest sM3Digest = this;
            this.W[n11] = sM3Digest.P1(sM3Digest.W[n11 - 16] ^ this.W[n11 - 9] ^ n9) ^ n7 ^ this.W[n11 - 6];
        }
        n11 = this.V[0];
        n10 = this.V[1];
        n9 = this.V[2];
        n8 = this.V[3];
        n7 = this.V[4];
        int n12 = this.V[5];
        int n13 = this.V[6];
        int n14 = this.V[7];
        for (n6 = 0; n6 < 16; ++n6) {
            n5 = n11 << 12 | n11 >>> 20;
            n4 = n5 + n7 + T[n6];
            n4 = n4 << 7 | n4 >>> 25;
            n5 = n4 ^ n5;
            n3 = this.W[n6];
            n2 = n3 ^ this.W[n6 + 4];
            n5 = this.FF0(n11, n10, n9) + n8 + n5 + n2;
            n4 = this.GG0(n7, n12, n13) + n14 + n4 + n3;
            n8 = n9;
            n9 = n10 << 9 | n10 >>> 23;
            n10 = n11;
            n11 = n5;
            n14 = n13;
            n13 = n12 << 19 | n12 >>> 13;
            n12 = n7;
            n7 = this.P0(n4);
        }
        for (n6 = 16; n6 < 64; ++n6) {
            n5 = n11 << 12 | n11 >>> 20;
            n4 = n5 + n7 + T[n6];
            n4 = n4 << 7 | n4 >>> 25;
            n5 = n4 ^ n5;
            n3 = this.W[n6];
            n2 = n3 ^ this.W[n6 + 4];
            n5 = this.FF1(n11, n10, n9) + n8 + n5 + n2;
            n4 = this.GG1(n7, n12, n13) + n14 + n4 + n3;
            n8 = n9;
            n9 = n10 << 9 | n10 >>> 23;
            n10 = n11;
            n11 = n5;
            n14 = n13;
            n13 = n12 << 19 | n12 >>> 13;
            n12 = n7;
            n7 = this.P0(n4);
        }
        this.V[0] = this.V[0] ^ n11;
        this.V[1] = this.V[1] ^ n10;
        this.V[2] = this.V[2] ^ n9;
        this.V[3] = this.V[3] ^ n8;
        this.V[4] = this.V[4] ^ n7;
        this.V[5] = this.V[5] ^ n12;
        this.V[6] = this.V[6] ^ n13;
        this.V[7] = this.V[7] ^ n14;
        this.xOff = 0;
    }

    @Override
    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 256, this.purpose);
    }

    static {
        int n2;
        T = new int[64];
        for (n2 = 0; n2 < 16; ++n2) {
            SM3Digest.T[n2] = 2043430169 << n2 | 2043430169 >>> 32 - n2;
        }
        for (n2 = 16; n2 < 64; ++n2) {
            int n3 = n2 % 32;
            SM3Digest.T[n2] = 2055708042 << n3 | 2055708042 >>> 32 - n3;
        }
    }
}

