/*
 * Decompiled with CFR 0.152.
 */
package com.org.bouncycastle.crypto.digests;

import com.org.bouncycastle.crypto.CryptoServiceProperties;
import com.org.bouncycastle.crypto.CryptoServicePurpose;
import com.org.bouncycastle.crypto.Digest;

class Utils {
    Utils() {
    }

    static CryptoServiceProperties getDefaultProperties(Digest digest, int n2, CryptoServicePurpose cryptoServicePurpose) {
        return new DefaultPropertiesWithPRF(digest.getDigestSize() << 2, n2, digest.getAlgorithmName(), cryptoServicePurpose);
    }

    private static class DefaultPropertiesWithPRF
    implements CryptoServiceProperties {
        private final int bitsOfSecurity;
        private final int prfBitsOfSecurity;
        private final String algorithmName;
        private final CryptoServicePurpose purpose;

        public DefaultPropertiesWithPRF(int n2, int n3, String string, CryptoServicePurpose cryptoServicePurpose) {
            this.bitsOfSecurity = n2;
            this.prfBitsOfSecurity = n3;
            this.algorithmName = string;
            this.purpose = cryptoServicePurpose;
        }

        @Override
        public int bitsOfSecurity() {
            if (this.purpose == CryptoServicePurpose.PRF) {
                return this.prfBitsOfSecurity;
            }
            return this.bitsOfSecurity;
        }

        @Override
        public String getServiceName() {
            return this.algorithmName;
        }

        @Override
        public CryptoServicePurpose getPurpose() {
            return this.purpose;
        }

        @Override
        public Object getParams() {
            return null;
        }
    }
}

