/*
 * Decompiled with CFR 0.152.
 */
package com.oscar;

import com.oscar.Config;
import com.oscar.DriverInfo;
import com.oscar.dispatcher.entity.DispatchConnection;
import com.oscar.jdbc.OscarJdbc2BulkConnection;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarJdbc2RacConnection;
import com.oscar.util.MessageTranslator;
import com.oscar.util.OSQLException;
import com.oscar.util.TrackLog;
import com.oscar.util.VersionConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class Driver
implements java.sql.Driver {
    private static volatile TrackLog trackLog;
    public static final AtomicInteger sessionID;
    public static final boolean debug = false;
    public static final boolean err = true;
    public static final boolean out = false;
    public static final String AUTH_TYPE_PW = "PW";
    public static final String AUTH_TYPE_OS = "OS";
    public static final String AUTH_TYPE_FP = "FP";
    public static final String AUTH_TYPE_RA = "RA";
    public static final boolean JDBC3;
    private VersionConfig versionConfig = VersionConfig.getInstance();
    private static Config config;
    private static final Object[][] knownProperties;
    final ThreadLocal<Random> random = new ThreadLocal<Random>(this){
        private /* synthetic */ Driver a;
        {
            this.a = driver;
        }

        @Override
        protected final /* synthetic */ Object initialValue() {
            return new Random();
        }
    };
    private static Set<String> hostSet;

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        return this.connect(string, properties, null);
    }

    public Connection connect(String string, Properties properties, OscarJdbc2Connection oscarJdbc2Connection) throws SQLException {
        try {
            if (JDBC3) {
                String string2;
                if ((properties = this.parseURL(string, properties)) == null) {
                    return null;
                }
                this.checkTrackLog(properties);
                if (Driver.getLogLevel() != 0) {
                    trackLog.writeLog("jdbc version:: " + DriverInfo.getVersion());
                    trackLog.writeLog("jdbc connect start:: " + string);
                }
                long l2 = (string2 = properties.getProperty("LOGINTIMEOUT")) != null ? (long)Float.parseFloat(string2) : (long)(DriverManager.getLoginTimeout() * 1000);
                int n2 = 0;
                if (Boolean.valueOf(properties.getProperty("RWHA", "FALSE")).booleanValue()) {
                    n2 = 1;
                } else {
                    try {
                        n2 = Integer.parseInt(properties.getProperty("RWHA", "0"));
                    }
                    catch (Exception exception) {}
                }
                if (Boolean.valueOf(properties.getProperty("USEDISPATCH", "FALSE")).booleanValue()) {
                    return this.dispatchConnection(l2, string, properties, n2);
                }
                if (properties.get("DBHOSTS") != null && Boolean.valueOf(properties.getProperty("FAILOVER", "false")).booleanValue()) {
                    properties.setProperty("CLEANSTATEMENT", "true");
                    properties.setProperty("URL", string);
                    return this.racConnection(l2, string, properties, oscarJdbc2Connection);
                }
                if (n2 == 1 || n2 == 2) {
                    return this.masterConnection(l2, string, properties, n2);
                }
                return this.commonConnection(l2, string, properties, null);
            }
            throw new SQLException("not support jdbc2.0");
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            throw sQLException;
        }
        catch (Exception exception) {
            Driver.writeLog("jdbc connect Exception,", exception);
            throw new SQLException(exception.getMessage(), exception);
        }
    }

    private Connection commonConnection(long l2, String object, Properties properties, OscarJdbc2Connection oscarJdbc2Connection) throws SQLException {
        if (l2 <= 0L) {
            return this.makeConnection(oscarJdbc2Connection, (String)object, properties);
        }
        object = new a(this, (String)object, properties, oscarJdbc2Connection);
        new Thread((Runnable)object, "OSCAR JDBC driver connection thread " + object.hashCode()).start();
        return ((a)object).a(l2);
    }

    private Connection racConnection(long l2, String string, Properties properties, OscarJdbc2Connection oscarJdbc2Connection) throws SQLException {
        Object object = properties.get("DBHOSTS");
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (properties.get("RAC_HOST_INIT_INDEX") != null) {
            n3 = Integer.parseInt(properties.get("RAC_HOST_INIT_INDEX").toString());
            n4 = Integer.parseInt(properties.get("RAC_HOST_END_INDEX").toString());
        }
        while (true) {
            try {
                return this.commonConnection(l2, string, properties, oscarJdbc2Connection);
            }
            catch (SQLException sQLException) {
                String[] stringArray = (String[])object;
                if (n2 == -1) {
                    n2 = n3 + 1 == stringArray.length ? 0 : n3 + 1;
                } else {
                    ++n2;
                    if (n4 > n3) {
                        if (n2 > n4) {
                            throw sQLException;
                        }
                    } else {
                        if (n2 == n4 + 1) {
                            throw sQLException;
                        }
                        if (n2 >= stringArray.length) {
                            n2 = 0;
                        }
                    }
                }
                this.setNextHost(stringArray, n2, properties);
                continue;
            }
            break;
        }
    }

    private Connection dispatchConnection(long l2, String string, Properties properties, int n2) throws SQLException {
        boolean bl = true;
        String[] stringArray = properties.get("DBHOSTS");
        stringArray = stringArray != null ? (String[])stringArray : null;
        String string2 = properties.getProperty("DBHOSTS_INDEX");
        int n3 = string2 == null ? -1 : Integer.parseInt(string2);
        Connection connection = null;
        do {
            try {
                Connection connection2 = this.commonConnection(l2, string, properties, null);
                if (stringArray == null || ((OscarJdbc2Connection)connection2).isMaster()) {
                    String string3 = properties.getProperty("PASSWORD") == null ? "" : properties.getProperty("PASSWORD");
                    String string4 = properties.getProperty("DBNAME", "");
                    connection2 = com.oscar.dispatcher.a.a.a((OscarJdbc2Connection)connection2, string3, string4, properties, ((OscarJdbc2Connection)connection2).initSlavesInfo(properties));
                }
                if (stringArray != null) {
                    if (connection2 instanceof DispatchConnection) {
                        bl = false;
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        return connection2;
                    }
                    if (connection == null) {
                        connection = connection2;
                    } else {
                        try {
                            connection2.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (++n3 >= stringArray.length) {
                        if (n2 == 2) {
                            return connection;
                        }
                        throw new OSQLException("OSCAR-00126", "88888", 126);
                    }
                } else {
                    return connection2;
                }
                this.setNextHost(stringArray, n3, properties);
            }
            catch (SQLException sQLException) {
                if (string2 != null) {
                    if (++n3 >= stringArray.length) {
                        if (connection != null) {
                            if (n2 == 2) {
                                return connection;
                            }
                            throw new OSQLException("OSCAR-00126", "88888", 126);
                        }
                        throw sQLException;
                    }
                    this.setNextHost(stringArray, n3, properties);
                    continue;
                }
                throw sQLException;
            }
        } while (bl);
        return null;
    }

    private Connection masterConnection(long l2, String string, Properties properties, int n2) throws SQLException {
        boolean bl = true;
        String[] stringArray = properties.get("DBHOSTS");
        stringArray = stringArray != null ? (String[])stringArray : null;
        String string2 = properties.getProperty("DBHOSTS_INDEX");
        int n3 = string2 == null ? -1 : Integer.parseInt(string2);
        Connection connection = null;
        boolean bl2 = false;
        do {
            try {
                Connection connection2 = this.commonConnection(l2, string, properties, null);
                if (stringArray != null) {
                    if (((OscarJdbc2Connection)connection2).isMaster()) {
                        bl = false;
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        return connection2;
                    }
                    if (connection == null) {
                        connection = connection2;
                    } else {
                        try {
                            connection2.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (++n3 >= stringArray.length) {
                        if (n2 == 2) {
                            return connection;
                        }
                        bl2 = true;
                        throw new OSQLException("OSCAR-00126", "88888", 126);
                    }
                } else {
                    return connection2;
                }
                this.setNextHost(stringArray, n3, properties);
            }
            catch (SQLException sQLException) {
                if (string2 != null && !bl2) {
                    if (++n3 >= stringArray.length) {
                        if (connection != null) {
                            if (n2 == 2) {
                                return connection;
                            }
                            throw new OSQLException("OSCAR-00126", "88888", 126);
                        }
                        throw sQLException;
                    }
                    this.setNextHost(stringArray, n3, properties);
                    continue;
                }
                throw sQLException;
            }
        } while (bl);
        return null;
    }

    public void setNextHost(String[] object, int n2, Properties properties) {
        StringTokenizer stringTokenizer = new StringTokenizer((String)(object = object[n2]), ":", true);
        if (stringTokenizer.countTokens() == 1) {
            properties.put("DBHOST", object);
            return;
        }
        int n3 = ((String)object).lastIndexOf(":");
        String string = ((String)object).substring(0, n3);
        object = ((String)object).substring(n3 + 1, ((String)object).length());
        properties.put("DBHOST", string);
        properties.put("DBPORT", Integer.decode((String)object).toString());
    }

    protected OscarJdbc2Connection initOscarConn(Properties object) {
        boolean bl = Boolean.valueOf(((Properties)object).getProperty("USEBULKINSERTBATCH", "FALSE"));
        object = bl ? new OscarJdbc2BulkConnection() : (((Properties)object).get("DBHOSTS") != null && Boolean.valueOf(((Properties)object).getProperty("FAILOVER", "false")) != false ? new OscarJdbc2RacConnection() : new OscarJdbc2Connection());
        return object;
    }

    private Connection makeConnection(OscarJdbc2Connection oscarJdbc2Connection, String string, Properties properties) throws SQLException {
        if (oscarJdbc2Connection == null) {
            oscarJdbc2Connection = this.initOscarConn(properties);
        }
        oscarJdbc2Connection.sessionID = sessionID.getAndIncrement();
        String string2 = properties.getProperty("DBHOST", "localhost");
        int n2 = Integer.parseInt(properties.getProperty("DBPORT", "2003"));
        String string3 = properties.getProperty("DBNAME", "");
        oscarJdbc2Connection.openConnection(string2, n2, properties, string3, string, this);
        if (trackLog != null && trackLog.getLogLevel() > 0) {
            trackLog.writeLog("session " + oscarJdbc2Connection.getSessionID() + " JDBC \u8fde\u63a5\u4fe1\u606f\uff1a" + properties.toString());
        }
        return oscarJdbc2Connection;
    }

    private void checkTrackLog(Properties object) {
        Object object2 = ((Properties)object).get("LOGLEVEL");
        if (object2 != null && trackLog == null) {
            Class<Driver> clazz = Driver.class;
            synchronized (Driver.class) {
                if (trackLog == null) {
                    int n2 = Integer.parseInt(object2.toString());
                    Object object3 = ((Properties)object).get("LOGFILEPATH");
                    String string = Config.getDefultLogPath();
                    if (object3 != null && !"".equals(object3)) {
                        string = object3.toString();
                    }
                    object = ((Properties)object).get("MAXFILESIZE");
                    trackLog = TrackLog.getInstance(n2, string, object);
                }
                // ** MonitorExit[var3_5] (shouldn't be in output)
                return;
            }
        }
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return this.parseURL(string, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String object, Properties driverPropertyInfoArray) throws SQLException {
        object = this.parseURL((String)object, (Properties)driverPropertyInfoArray);
        driverPropertyInfoArray = new DriverPropertyInfo[knownProperties.length];
        for (int i2 = 0; i2 < knownProperties.length; ++i2) {
            String string = (String)knownProperties[i2][0];
            String string2 = ((Properties)object).getProperty(string);
            driverPropertyInfoArray[i2] = new DriverPropertyInfo(string, string2);
            driverPropertyInfoArray[i2].required = (Boolean)knownProperties[i2][1];
            driverPropertyInfoArray[i2].description = (String)knownProperties[i2][2];
            if (string2 == null && knownProperties[i2].length > 3) {
                driverPropertyInfoArray[i2].value = (String)knownProperties[i2][3];
            }
            if (knownProperties[i2].length <= 4) continue;
            driverPropertyInfoArray[i2].choices = (String[])knownProperties[i2][4];
        }
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return this.versionConfig.getDriverMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.versionConfig.getDriverMinorVersion();
    }

    public static String getVersion() {
        VersionConfig versionConfig = VersionConfig.getInstance();
        return versionConfig.getDriverMajorVersion() + "." + versionConfig.getDriverMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Properties parseURL(String object, Properties object2) throws SQLException {
        String string;
        Object object3;
        String[] stringArray;
        String string2;
        int n2;
        Properties properties;
        block41: {
            Object object4;
            properties = new Properties();
            n2 = -1;
            if (object2 != null) {
                Enumeration<Object> enumeration = ((Properties)object2).keys();
                while (enumeration.hasMoreElements()) {
                    object4 = enumeration.nextElement();
                    string2 = ((String)object4).toUpperCase();
                    properties.put(string2, ((Properties)object2).get(object4));
                }
            }
            object4 = object;
            string2 = "";
            int n3 = ((String)object).indexOf(63);
            if (n3 == -1) {
                n3 = ((String)object).indexOf(59);
            }
            if (n3 != -1) {
                object4 = ((String)object).substring(0, n3);
                string2 = ((String)object).substring(n3 + 1);
            }
            object = new StringTokenizer((String)object4, "/", true);
            stringArray = null;
            String[] stringArray2 = this.getProtocols();
            int n4 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                block40: {
                    block45: {
                        int n5;
                        block44: {
                            block43: {
                                object4 = ((StringTokenizer)object).nextToken();
                                if (n4 != 0) break block43;
                                object2 = new StringTokenizer((String)object4, ":", true);
                                n5 = 0;
                                while (((StringTokenizer)object2).hasMoreTokens()) {
                                    if (n5 > 3) return null;
                                    if (!((StringTokenizer)object2).nextToken().equals(stringArray2[n5])) {
                                        return null;
                                    }
                                    ++n5;
                                }
                                break block40;
                            }
                            if (n4 != 1 && n4 != 2) break block44;
                            n2 = 1;
                            break block40;
                        }
                        if (n4 != 3 || n2 != 1) break block45;
                        if (((String)object4).indexOf(",") != -1) {
                            stringArray = ((String)object4).split(",");
                            break block40;
                        } else {
                            object2 = new StringTokenizer((String)object4, ":", true);
                            if (((StringTokenizer)object2).countTokens() == 1) {
                                properties.put("DBHOST", object4);
                                break block40;
                            } else {
                                n5 = ((String)object4).lastIndexOf(":");
                                object3 = ((String)object4).substring(0, n5);
                                object4 = ((String)object4).substring(n5 + 1, ((String)object4).length());
                                n2 = ((StringTokenizer)object2).countTokens() > 1 ? 2 : 3;
                                properties.put("DBHOST", object3);
                                properties.put("DBPORT", Integer.decode((String)object4).toString());
                            }
                        }
                        break block40;
                    }
                    if (n4 == 4) {
                        n2 = 4;
                    } else if (n4 == 5 && n2 == 4) {
                        properties.put("DBNAME", object4);
                        n2 = -2;
                    }
                }
                ++n4;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            while (stringTokenizer.hasMoreTokens()) {
                object3 = stringTokenizer.nextToken().trim();
                int n6 = ((String)object3).indexOf(61);
                if (n6 == -1) {
                    properties.put(((String)object3).toUpperCase().trim(), "");
                    continue;
                }
                object = ((String)object3).substring(0, n6);
                object2 = ((String)object3).substring(n6 + 1);
                if (object == null || object2 == null) continue;
                properties.put(((String)object).toUpperCase().trim(), ((String)object2).trim());
            }
            Object object5 = properties.get("CONFIGFILE");
            if (object5 != null) {
                object3 = new Properties();
                InputStream inputStream = null;
                try {
                    object = new File(object5.toString());
                    if (((File)object).exists()) {
                        inputStream = new FileInputStream((File)object);
                        object2 = new Properties();
                        ((Properties)object2).load(inputStream);
                        object = ((Properties)object2).keys();
                        while (object.hasMoreElements()) {
                            Object e2 = object.nextElement();
                            string2 = ((String)e2).toUpperCase();
                            ((Properties)object3).put(string2, ((Properties)object2).get(e2));
                        }
                    }
                    if (inputStream == null) break block41;
                }
                catch (IOException iOException) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block41;
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            } else {
                object3 = Config.getConfigProp();
            }
        }
        if (object3 != null) {
            Enumeration<Object> enumeration = ((Properties)object3).keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (properties.get(object) != null) continue;
                properties.put(object, ((Properties)object3).get(object));
            }
        }
        if (stringArray == null) return properties;
        properties.put("DBHOSTS", stringArray);
        if (Boolean.valueOf(properties.getProperty("LOADBALANCE", "FALSE")).booleanValue() && !Boolean.valueOf(properties.getProperty("USEDISPATCH", "FALSE")).booleanValue()) {
            if (hostSet.size() > 0) {
                object = hostSet.iterator();
                object2 = new ArrayList<String>(Arrays.asList(stringArray));
                n2 = 0;
                while (object.hasNext()) {
                    string2 = (String)object.next();
                    if (object2.contains(string2)) continue;
                    object2.add(string2);
                    n2 = 1;
                }
                if (n2 != 0) {
                    stringArray = new String[object2.size()];
                    object2.toArray(stringArray);
                    properties.put("DBHOSTS", stringArray);
                }
            }
            int n7 = this.random.get().nextInt(stringArray.length);
            string = stringArray[n7];
            properties.put("RAC_HOST_INIT_INDEX", (Object)n7);
            if (n7 == 0) {
                properties.put("RAC_HOST_END_INDEX", (Object)(stringArray.length - 1));
            } else {
                properties.put("RAC_HOST_END_INDEX", (Object)(n7 - 1));
            }
        } else {
            string = stringArray[0];
            properties.put("RAC_HOST_INIT_INDEX", (Object)0);
            properties.put("RAC_HOST_END_INDEX", (Object)(stringArray.length - 1));
        }
        properties.setProperty("DBHOSTS_INDEX", "0");
        object2 = new StringTokenizer(string, ":", true);
        if (((StringTokenizer)object2).countTokens() == 1) {
            properties.put("DBHOST", string);
            return properties;
        }
        int n8 = string.lastIndexOf(":");
        object2 = string.substring(0, n8);
        String string3 = string.substring(n8 + 1, string.length());
        properties.put("DBHOST", object2);
        properties.put("DBPORT", Integer.decode(string3).toString());
        return properties;
    }

    public static SQLException notImplemented() throws SQLException {
        return new SQLFeatureNotSupportedException("oscar.unimplemented");
    }

    public static boolean sslEnabled() {
        return true;
    }

    public static int getLogLevel() {
        if (trackLog == null) {
            return 0;
        }
        return trackLog.getLogLevel();
    }

    public static void writeLog(String string) {
        if (trackLog != null && (trackLog.getLogLevel() > 0 || trackLog.getLogLevel() == -1)) {
            trackLog.writeLog(string);
        }
    }

    public static void writeLog(Integer n2, int n3, String string) {
        if (trackLog != null && (trackLog.getLogLevel() > 0 || trackLog.getLogLevel() == -1)) {
            trackLog.writeLog("conid: " + n2 + ", /*Session " + n3 + "*/ " + string);
        }
    }

    public static void writeLog(String string, Throwable object) {
        if (trackLog != null && (trackLog.getLogLevel() > 0 || trackLog.getLogLevel() == -1)) {
            object = Driver.getStackTrace((Throwable)object);
            object = string == null ? object : string + " " + (String)object;
            trackLog.writeLog((String)object);
        }
    }

    public static void writeLog(Throwable throwable) {
        Driver.writeLog(null, throwable);
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)stringWriter, true);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
        }
        catch (Throwable throwable2) {
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable2;
        }
        return stringWriter.getBuffer().toString();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    protected String[] getProtocols() {
        return new String[]{"jdbc", ":", "oscar", ":"};
    }

    public static Set<String> getHostSet() {
        return hostSet;
    }

    static {
        sessionID = new AtomicInteger(0);
        JDBC3 = "1.4".compareTo(System.getProperty("java.specification.version")) <= 0;
        knownProperties = new Object[][]{{"DBNAME", Boolean.TRUE, MessageTranslator.translate("DRIVER_DBNAME")}, {"DBHOST", Boolean.TRUE, MessageTranslator.translate("DRIVER_DBHOST")}, {"DBPORT", Boolean.TRUE, "DRIVER_DBPORT"}, {"LOGLEVEL", Boolean.FALSE, MessageTranslator.translate("DRIVER_LOGLEVEL"), "0", new String[]{"0", "1", "2", "3", "4"}}, {"LOGFILEPATH", Boolean.FALSE, MessageTranslator.translate("DRIVER_LOGFILEPATH")}, {"LOGINTIMEOUT", Boolean.FALSE, MessageTranslator.translate("DRIVER_LOGINTIMEOUT"), "0"}, {"REQUESTTIMEOUT", Boolean.FALSE, MessageTranslator.translate("DRIVER_REQUESTTIMEOUT"), "0"}, {"NOTREALPREPARE", Boolean.FALSE, MessageTranslator.translate("DRIVER_NOTREALPREPARE"), "false", new String[]{"true", "false"}}, {"COMPATIBLEOLDPROTOCOL", Boolean.FALSE, MessageTranslator.translate("DRIVER_COMPATIBLEOLDPROTOCOL"), "false", new String[]{"true", "false"}}, {"FETCHSIZE", Boolean.FALSE, MessageTranslator.translate("DRIVER_FETCHSIZE"), "16"}, {"PREPARESIMPLEEXECUTE", Boolean.FALSE, MessageTranslator.translate("DRIVER_PREPARESIMPLEEXECUTE"), "true", new String[]{"true", "false"}}, {"VERIFYPOOLCONNECTIN", Boolean.FALSE, MessageTranslator.translate("DRIVER_VERIFYPOOLCONNECTIN"), "false", new String[]{"true", "false"}}, {"USEASYNBATCH", Boolean.FALSE, MessageTranslator.translate("DRIVER_USEASYNBATCH"), "false", new String[]{"true", "false"}}, {"BATCHCOUNT", Boolean.FALSE, MessageTranslator.translate("DRIVER_BATCHCOUNT"), "0"}, {"TCPKEEPALIVE", Boolean.FALSE, MessageTranslator.translate("DRIVER_TCPKEEPALIVE"), "false", new String[]{"true", "false"}}, {"USEDISPATCH", Boolean.FALSE, MessageTranslator.translate("DRIVER_USEDISPATCH"), "false", new String[]{"true", "false"}}, {"USEASYNCHRONOUS", Boolean.FALSE, MessageTranslator.translate("DRIVER_USEASYNCHRONOUS"), "true", new String[]{"true", "false"}}, {"USESLAVESYNCREAD", Boolean.FALSE, MessageTranslator.translate("DRIVER_USESLAVESYNCREAD"), "false", new String[]{"true", "false"}}, {"TRANSACTIONDISPATCHSTRATEGY", Boolean.FALSE, MessageTranslator.translate("DRIVER_TRANSACTIONDISPATCHSTRATEGY"), "1", new String[]{"1", "2", "3"}}, {"VALIDTESTSTRING", Boolean.FALSE, MessageTranslator.translate("DRIVER_VALIDTESTSTRING"), "select 1", new String[]{"select 'mpp nodeagent probeing'", "select 'user direct testing'", "select 'mpp master probeing'"}}, {"CHECKDBLINKSQL", Boolean.FALSE, MessageTranslator.translate("DRIVER_CHECKDBLINKSQL"), "false", new String[]{"true", "false"}}, {"SENDBINARYTYPEASHEX", Boolean.FALSE, MessageTranslator.translate("DRIVER_SENDBINARYTYPEASHEX"), "false", new String[]{"true", "false"}}};
        hostSet = new HashSet<String>();
        try {
            config = new Config();
            config.init();
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            sQLException.printStackTrace();
        }
    }

    private final class a
    implements Runnable {
        private String a;
        private Properties b;
        private Connection c;
        private Throwable d;
        private boolean e = false;
        private OscarJdbc2Connection f = null;
        private /* synthetic */ Driver g;

        a(Driver driver, String string, Properties properties, OscarJdbc2Connection oscarJdbc2Connection) {
            this.g = driver;
            this.a = string;
            this.b = properties;
            if (oscarJdbc2Connection != null) {
                this.f = oscarJdbc2Connection;
                return;
            }
            this.f = driver.initOscarConn(properties);
        }

        @Override
        public final void run() {
            Object object;
            Throwable throwable;
            Connection connection = null;
            try {
                connection = this.g.makeConnection(this.f, this.a, this.b);
                throwable = null;
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throwable = throwable2;
            }
            object = this;
            synchronized (object) {
                if (this.e) {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.c = connection;
                    this.d = throwable;
                    this.notify();
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Connection a(long l2) throws SQLException {
            if (Driver.getLogLevel() != 0) {
                trackLog.writeLog("getResultAsConnection start, hashcode:" + this.hashCode());
            }
            long l3 = System.currentTimeMillis() + l2;
            a a2 = this;
            synchronized (a2) {
                while (true) {
                    if (this.c != null) {
                        if (Driver.getLogLevel() != 0) {
                            trackLog.writeLog("getResultAsConnection return, session: " + ((OscarJdbc2Connection)this.c).getSessionID() + " hashcode: " + this.hashCode());
                        }
                        return this.c;
                    }
                    if (this.d != null) {
                        Driver.writeLog(this.d);
                        if (this.d instanceof SQLException) {
                            Driver.writeLog("getResultAsConnection, hashcode: " + this.hashCode() + "exception on new connection:", this.d);
                            throw (SQLException)this.d;
                        }
                        Driver.writeLog("getResultAsConnection timeout1--" + l2 + " hashcode: " + this.hashCode());
                        throw new SQLException(this.d.getMessage(), this.d);
                    }
                    long l4 = l3 - System.currentTimeMillis();
                    if (l4 <= 0L) {
                        this.e = true;
                        if (this.f != null) {
                            this.f.close();
                        }
                        Driver.writeLog("getResultAsConnection timeout2--" + l2 + " hashcode: " + this.hashCode());
                        throw new OSQLException("OSCAR-00122", "08001", 122);
                    }
                    try {
                        this.wait(l4);
                    }
                    catch (InterruptedException interruptedException) {
                        this.e = true;
                        Driver.writeLog("getResultAsConnection timeout3--" + l2 + " hashcode: " + this.hashCode());
                        throw new OSQLException("OSCAR-00123", "08001", 123);
                    }
                }
            }
        }
    }
}

