/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ae;

import com.oscar.Driver;
import com.oscar.ae.CmkManager;
import com.oscar.ae.ColumnEncryptionKey;
import com.oscar.ae.ColumnMasterKey;
import com.oscar.ae.EncryptionCommon;
import com.oscar.ae.OscarCekStoreProvider;
import com.oscar.util.Hex;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class CekManager {
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    private final List<ColumnEncryptionKey> CEK_LIST = new CopyOnWriteArrayList<ColumnEncryptionKey>();
    private com.oscar.ae.a provider = new com.oscar.ae.a();

    private CekManager() {
    }

    public static CekManager singleton() {
        return a.a;
    }

    public ColumnEncryptionKey getCek(String string, String string2, String string3) throws Exception {
        ColumnMasterKey columnMasterKey;
        ColumnEncryptionKey columnEncryptionKey;
        int n2 = Collections.binarySearch(this.CEK_LIST, string);
        if (n2 >= 0) {
            columnEncryptionKey = this.CEK_LIST.get(n2);
            if (columnEncryptionKey.getKeyValueRaw() != null) {
                return columnEncryptionKey;
            }
        } else {
            columnEncryptionKey = new ColumnEncryptionKey();
            columnEncryptionKey.setEncryptedValue(string);
            columnEncryptionKey.setAlgorithmName(string3);
        }
        if ((columnMasterKey = CmkManager.singleton().getCmkOrFind(string2, Boolean.FALSE)) == null) {
            throw new SQLException("\u627e\u4e0d\u5230cmk:" + string2);
        }
        if (columnEncryptionKey.getCmk() != null) {
            columnMasterKey.setKeystoreName(columnEncryptionKey.getCmk().getKeystoreName());
        }
        string = this.decryptCek(string, columnMasterKey, string3);
        columnEncryptionKey.setCmk(columnMasterKey);
        columnEncryptionKey.setKeyValueRaw(string);
        this.cache(columnEncryptionKey);
        return columnEncryptionKey;
    }

    public synchronized void cache(ColumnEncryptionKey columnEncryptionKey) {
        int n2 = Collections.binarySearch(this.CEK_LIST, columnEncryptionKey);
        if (n2 < 0) {
            this.CEK_LIST.add(-n2 - 1, columnEncryptionKey);
        }
    }

    public ColumnEncryptionKey generateNew(Connection object, String string, ColumnMasterKey columnMasterKey) throws Exception {
        String string2 = this.createCekRaw();
        Object object2 = ((OscarCekStoreProvider)this.provider).encryptColumnEncryptionKey(columnMasterKey.getPath(), EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_128_CBC_HMAC_SHA256.name(), string2.getBytes());
        object2 = new String((byte[])object2, EncryptionCommon.ISO_8859_1);
        try {
            this.saveTo((Connection)object, columnMasterKey.getKeyName(), string, EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_128_CBC_HMAC_SHA256.name(), (String)object2);
        }
        catch (SQLException sQLException) {
            object = sQLException;
            sQLException.printStackTrace();
            throw object;
        }
        object = new ColumnEncryptionKey(string);
        ((ColumnEncryptionKey)object).setCmk(columnMasterKey);
        ((ColumnEncryptionKey)object).setKeyValueRaw(string2);
        ((ColumnEncryptionKey)object).setAlgorithmName(EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_128_CBC_HMAC_SHA256.name());
        ((ColumnEncryptionKey)object).setEncryptedValue((String)object2);
        return object;
    }

    public String decryptCek(String string, ColumnMasterKey columnMasterKey, String object) throws Exception {
        byte[] byArray = Hex.hexStringToByte(string);
        object = ((OscarCekStoreProvider)this.provider).decryptColumnEncryptionKey(columnMasterKey.getPath(), (String)object, byArray);
        if (this.logFlag) {
            Driver.writeLog("cmk\u660e\u6587 \u516c\u94a5:" + Arrays.toString(columnMasterKey.getPublicKeyInfo().getKeyValueRawBytes()));
            Driver.writeLog("cek\u5341\u516d\u8fdb\u5236\uff1a" + string);
            Driver.writeLog("cek\u5bc6\u6587\uff1a" + new String(byArray));
            Driver.writeLog("cek\u660e\u6587:" + new String((byte[])object, EncryptionCommon.ISO_8859_1));
        }
        return new String((byte[])object, EncryptionCommon.ISO_8859_1);
    }

    private String createCekRaw() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 16);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveTo(Connection connection, String object, String string, String string2, String string3) throws SQLException {
        String string4 = "CREATE COLUMN ENCRYPTION KEY %key_name%   \r\nWITH VALUES  \r\n  (  \r\n    COLUMN_MASTER_KEY = '%COLUMN_MASTER_KEY%',   \r\n    ALGORITHM = '%ALGORITHM%',     \r\n    ENCRYPTED_VALUE = '%ENCRYPTED_VALUE%'  \r\n  )";
        string4 = "CREATE COLUMN ENCRYPTION KEY %key_name%   \r\nWITH VALUES  \r\n  (  \r\n    COLUMN_MASTER_KEY = '%COLUMN_MASTER_KEY%',   \r\n    ALGORITHM = '%ALGORITHM%',     \r\n    ENCRYPTED_VALUE = '%ENCRYPTED_VALUE%'  \r\n  )".replaceFirst("%key_name%", string);
        string4 = string4.replaceFirst("%COLUMN_MASTER_KEY%", (String)object);
        string4 = string4.replaceFirst("%ALGORITHM%", string2);
        string4 = string4.replaceFirst("%ENCRYPTED_VALUE%", string3);
        object = null;
        try {
            object = connection.createStatement();
            object.execute(string4);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            object.close();
            throw throwable;
        }
        object.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void selectCekOid(Connection autoCloseable, ColumnEncryptionKey columnEncryptionKey) throws SQLException {
        String string = "select cek.CEKOID from v_sys_attribute_encrypted_key_values m,v_sys_attribute_master_keys cmk,v_sys_attribute_encrypted_keys cek where cmk.cmkoid=m.cmkoid and m.cekoid=cek.cekoid and cek.cekname=? and cmk.CMKNAME=?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = autoCloseable.prepareStatement(string);
            preparedStatement.setString(1, columnEncryptionKey.getKeyName());
            preparedStatement.setString(2, columnEncryptionKey.getCmk().getKeyName());
            autoCloseable = null;
            try {
                autoCloseable = preparedStatement.executeQuery();
                if (!autoCloseable.next()) throw new SQLException("\u6ca1\u6709\u67e5\u8be2\u5230cek oid, cekname:" + columnEncryptionKey.getKeyName() + ", cmkname:" + columnEncryptionKey.getCmk().getKeyName());
                long l2 = autoCloseable.getLong(1);
                columnEncryptionKey.setOid(l2);
            }
            finally {
                if (autoCloseable != null) {
                    autoCloseable.close();
                }
            }
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dropCek(Connection connection, String string) throws SQLException {
        string = "DROP COLUMN ENCRYPTION KEY " + string;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(string);
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }

    private static final class a {
        private static final CekManager a = new CekManager();
    }
}

