/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ae;

import com.oscar.Driver;
import com.oscar.ae.ColumnMasterKey;
import com.oscar.ae.EncryptionCommon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CmkManager {
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    private final Map<String, ColumnMasterKey> CMK_MAP = new ConcurrentHashMap<String, ColumnMasterKey>();
    private final SecureRandom secureRandom = new SecureRandom();
    private static final int CMK_FILE_PRIVATE_KEY = 1;
    private static final int CMK_FILE_PRIVATE_KEY_RAND = 2;
    private static final int CMK_FILE_PUBLIC_KEY = 3;
    private static final int CMK_FILE_PUBLIC_KEY_RAND = 4;
    private static final Map<Integer, String> CMK_FILE_POSTFIX_MAP = new HashMap<Integer, String>(){
        {
            this.put(1, ".pri");
            this.put(2, ".pri.rand");
            this.put(3, ".pub");
            this.put(4, ".pub.rand");
        }
    };

    private CmkManager() {
    }

    public static CmkManager singleton() {
        return a.a;
    }

    public ColumnMasterKey getCmkOrFind(String string, Boolean bl) throws Exception {
        ColumnMasterKey columnMasterKey = null;
        if (string != null) {
            columnMasterKey = this.CMK_MAP.get(string);
        }
        boolean bl2 = false;
        if (columnMasterKey != null) {
            if (bl == null) {
                bl2 = columnMasterKey.getPrivateKeyInfo() != null && columnMasterKey.getPublicKeyInfo() != null;
            } else {
                boolean bl3 = bl.booleanValue() ? columnMasterKey.getPrivateKeyInfo() != null : (bl2 = columnMasterKey.getPublicKeyInfo() != null);
            }
        }
        if (bl2) {
            return columnMasterKey;
        }
        ColumnMasterKey columnMasterKey2 = this.findLocalCmk(string, bl);
        if (columnMasterKey2 != null) {
            this.CMK_MAP.put(string, columnMasterKey2);
            if (bl != null && columnMasterKey != null) {
                if (bl.booleanValue()) {
                    columnMasterKey2.setPublicKeyInfo(columnMasterKey.getPublicKeyInfo());
                } else {
                    columnMasterKey2.setPrivateKeyInfo(columnMasterKey.getPrivateKeyInfo());
                }
            }
        }
        return columnMasterKey2;
    }

    public ColumnMasterKey findLocalCmk(String object, Boolean object2) throws Exception {
        if (object2 == null) {
            object2 = this.findLocalCmk((String)object, true);
            object = this.findLocalCmk((String)object, false);
            ((ColumnMasterKey)object2).setPublicKeyInfo(((ColumnMasterKey)object).getPublicKeyInfo());
            return object2;
        }
        return this.findLocalCmk((String)object, ((Boolean)object2).booleanValue());
    }

    public ColumnMasterKey findLocalCmk(String string, boolean bl) throws Exception {
        int n2 = bl ? 1 : 3;
        Object object = new File(string + CMK_FILE_POSTFIX_MAP.get(n2));
        if (!((File)object).isFile() || !((File)object).exists()) {
            throw new FileNotFoundException(((File)object).getAbsolutePath());
        }
        int n3 = bl ? 2 : 4;
        Object object2 = new File(string + CMK_FILE_POSTFIX_MAP.get(n3));
        if (!((File)object2).isFile() || !((File)object2).exists()) {
            throw new FileNotFoundException(((File)object2).getAbsolutePath());
        }
        object = CmkManager.readKeyFromFile((File)object);
        if (this.logFlag) {
            Driver.writeLog("---------------\u8bfb\u51fa\u7684 " + (bl ? "private" : "public") + " key \u5bc6\u6587---------------");
            Driver.writeLog(Arrays.toString((byte[])object));
        }
        object2 = CmkManager.readKeyFromFile((File)object2);
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[((Object)object2).length - byArray.length];
        System.arraycopy(object2, 0, byArray2, 0, byArray2.length);
        System.arraycopy(object2, byArray2.length, byArray, 0, byArray.length);
        if (this.logFlag) {
            Driver.writeLog("---------------\u8bfb\u51fa\u7684 " + (bl ? "private" : "public") + " rand---------------");
            Driver.writeLog(Arrays.toString(byArray2));
            Driver.writeLog(Arrays.toString(byArray));
        }
        object2 = new String(byArray2, EncryptionCommon.ISO_8859_1);
        object2 = EncryptionCommon.decryptKey_AES128_CBC_HMAC_SHA256((byte[])object, (String)object2, byArray);
        if (this.logFlag) {
            Driver.writeLog("---------------\u89e3\u5bc6\u7684 " + (bl ? "private" : "public") + " key---------------");
            Driver.writeLog(Arrays.toString((byte[])object2));
        }
        ColumnMasterKey columnMasterKey = new ColumnMasterKey();
        if (bl) {
            columnMasterKey.setPrivateKeyInfo(byArray2, byArray, (byte[])object2, (byte[])object);
        } else {
            columnMasterKey.setPublicKeyInfo(byArray2, byArray, (byte[])object2, (byte[])object);
        }
        columnMasterKey.setPath(string);
        return columnMasterKey;
    }

    public ColumnMasterKey generateNew(Connection connection, String object, String string, String string2) throws Exception {
        Object object2;
        ColumnMasterKey columnMasterKey = new ColumnMasterKey();
        columnMasterKey.setKeyName(string);
        object = new File((String)object);
        ((File)object).mkdirs();
        HashMap<Integer, File> hashMap = new HashMap<Integer, File>();
        for (Map.Entry<Integer, String> object32 : CMK_FILE_POSTFIX_MAP.entrySet()) {
            File file = new File((File)object, string + object32.getValue());
            if (file.isFile() && file.exists()) {
                throw new Exception("\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff1a" + file.getAbsolutePath());
            }
            hashMap.put(object32.getKey(), file);
        }
        for (File file : hashMap.values()) {
            if (file.exists() || file.createNewFile()) continue;
            this.deleteAllFile(hashMap);
            throw new Exception("\u6587\u4ef6\u521b\u5efa\u5931\u8d25:" + file);
        }
        this._generateKey(columnMasterKey);
        try {
            object2 = columnMasterKey.getPrivateKeyInfo();
            ColumnMasterKey.KeyInfo keyInfo = columnMasterKey.getPublicKeyInfo();
            CmkManager.saveKeyToFile(((ColumnMasterKey.KeyInfo)object2).getEncryptedValueBytes(), (File)hashMap.get(1));
            CmkManager.saveKeyToFile(keyInfo.getEncryptedValueBytes(), (File)hashMap.get(3));
            int n2 = ((ColumnMasterKey.KeyInfo)object2).getSecretKeyBytes().length;
            int n3 = ((ColumnMasterKey.KeyInfo)object2).getIvBytes().length;
            byte[] byArray = new byte[n2 + n3];
            System.arraycopy(((ColumnMasterKey.KeyInfo)object2).getSecretKeyBytes(), 0, byArray, 0, n2);
            System.arraycopy(((ColumnMasterKey.KeyInfo)object2).getIvBytes(), 0, byArray, n2, n3);
            CmkManager.saveKeyToFile(byArray, (File)hashMap.get(2));
            n2 = keyInfo.getSecretKeyBytes().length;
            n3 = keyInfo.getIvBytes().length;
            byArray = new byte[n2 + n3];
            System.arraycopy(keyInfo.getSecretKeyBytes(), 0, byArray, 0, n2);
            System.arraycopy(keyInfo.getIvBytes(), 0, byArray, n2, n3);
            CmkManager.saveKeyToFile(byArray, (File)hashMap.get(4));
        }
        catch (Exception exception) {
            if (this.logFlag) {
                Driver.writeLog(exception);
            }
            this.deleteAllFile(hashMap);
            throw exception;
        }
        object2 = new File((File)object, string);
        String string4 = ((File)object2).getAbsolutePath();
        string4 = string4.replaceAll("\\\\", "/");
        columnMasterKey.setPath(string4);
        try {
            this.saveTo(connection, string, string2, string4);
        }
        catch (Exception exception) {
            if (this.logFlag) {
                Driver.writeLog(exception);
            }
            this.deleteAllFile(hashMap);
            throw exception;
        }
        return columnMasterKey;
    }

    private void deleteAllFile(Map<Integer, File> map) {
        File file = map.get(1);
        if (file != null) {
            file.delete();
        }
        if ((file = map.get(2)) != null) {
            file.delete();
        }
        if ((file = map.get(3)) != null) {
            file.delete();
        }
        if ((file = map.get(4)) != null) {
            file.delete();
        }
        map.clear();
    }

    protected String createPassword() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 16);
    }

    protected byte[] createBytes(int n2) {
        byte[] byArray = new byte[n2];
        this.secureRandom.nextBytes(byArray);
        return byArray;
    }

    private ColumnMasterKey _generateKey(ColumnMasterKey columnMasterKey) throws Exception {
        KeyPair keyPair = EncryptionCommon.generateKeyPair();
        this.encryptKey(columnMasterKey, keyPair.getPrivate());
        this.encryptKey(columnMasterKey, keyPair.getPublic());
        return columnMasterKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveTo(Connection connection, String object, String string, String string2) throws SQLException {
        String string3 = "CREATE COLUMN MASTER KEY %key_name%   \r\n    WITH (  \r\n        KEY_STORE_PROVIDER_NAME = '%KEY_STORE_PROVIDER_NAME%',  \r\n        KEY_PATH = '%KEY_PATH%'  \r\n         )";
        string3 = "CREATE COLUMN MASTER KEY %key_name%   \r\n    WITH (  \r\n        KEY_STORE_PROVIDER_NAME = '%KEY_STORE_PROVIDER_NAME%',  \r\n        KEY_PATH = '%KEY_PATH%'  \r\n         )".replaceFirst("%key_name%", (String)object);
        string3 = string3.replaceFirst("%KEY_STORE_PROVIDER_NAME%", string);
        string3 = string3.replaceFirst("%KEY_PATH%", string2);
        object = null;
        try {
            object = connection.createStatement();
            object.execute(string3);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            object.close();
            throw throwable;
        }
        object.close();
    }

    public void encryptKey(ColumnMasterKey columnMasterKey, PrivateKey privateKey) throws Exception {
        String string = this.createPassword();
        byte[] byArray = this.createBytes(16);
        byte[] byArray2 = EncryptionCommon.encryptKey_AES128_CBC_HMAC_SHA256(privateKey.getEncoded(), string, byArray);
        columnMasterKey.setPrivateKeyInfo(string.getBytes(EncryptionCommon.ISO_8859_1), byArray, privateKey.getEncoded(), byArray2);
        if (this.logFlag) {
            Driver.writeLog("cmk privatekey \u660e\u6587:" + Arrays.toString(columnMasterKey.getPrivateKeyInfo().getKeyValueRawBytes()));
            Driver.writeLog("cmk privatekey SecretKey:" + Arrays.toString(columnMasterKey.getPrivateKeyInfo().getSecretKeyBytes()));
            Driver.writeLog("cmk privatekey iv:" + Arrays.toString(columnMasterKey.getPrivateKeyInfo().getIvBytes()));
            Driver.writeLog("cmkprivatekey \u5bc6\u6587:" + Arrays.toString(columnMasterKey.getPrivateKeyInfo().getEncryptedValueBytes()));
        }
    }

    public void encryptKey(ColumnMasterKey columnMasterKey, PublicKey publicKey) throws Exception {
        String string = this.createPassword();
        byte[] byArray = this.createBytes(16);
        byte[] byArray2 = EncryptionCommon.encryptKey_AES128_CBC_HMAC_SHA256(publicKey.getEncoded(), string, byArray);
        columnMasterKey.setPublicKeyInfo(string.getBytes(), byArray, publicKey.getEncoded(), byArray2);
        if (this.logFlag) {
            Driver.writeLog("cmk publickey \u660e\u6587:" + Arrays.toString(columnMasterKey.getPublicKeyInfo().getKeyValueRawBytes()));
            Driver.writeLog("cmk publickey SecretKey:" + Arrays.toString(columnMasterKey.getPublicKeyInfo().getSecretKeyBytes()));
            Driver.writeLog("cmk publickey iv:" + Arrays.toString(columnMasterKey.getPublicKeyInfo().getIvBytes()));
            Driver.writeLog("cmk publickey \u5bc6\u6587:" + Arrays.toString(columnMasterKey.getPublicKeyInfo().getEncryptedValueBytes()));
        }
    }

    public static void saveKeyToFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
        catch (Throwable throwable) {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw throwable;
        }
        fileOutputStream.close();
    }

    public static byte[] readKeyFromFile(File object) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream((File)object);
            object = new byte[fileInputStream.available()];
            fileInputStream.read((byte[])object);
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            throw throwable;
        }
        fileInputStream.close();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dropCmk(Connection object, String object2, String string) throws SQLException {
        block5: {
            Statement statement;
            object2 = "DROP COLUMN MASTER KEY " + object2;
            Statement object3 = null;
            try {
                statement = object.createStatement();
                statement.execute((String)((Object)object2));
                if (statement == null) break block5;
            }
            catch (Throwable throwable) {
                if (object3 != null) {
                    object3.close();
                }
                throw throwable;
            }
            statement.close();
        }
        object = new HashMap();
        object2 = CMK_FILE_POSTFIX_MAP.entrySet().iterator();
        while (true) {
            if (!object2.hasNext()) {
                this.deleteAllFile(object);
                return;
            }
            Map.Entry<Integer, String> entry = object2.next();
            File file = new File(string + entry.getValue());
            if (!file.isFile() || !file.exists()) continue;
            object.put(entry.getKey(), file);
        }
    }

    private static final class a {
        private static final CmkManager a = new CmkManager();
    }
}

