/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ae;

import com.oscar.Driver;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionCommon {
    protected static final boolean logFlag = Driver.getLogLevel() >= 2;
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final int HMAC_COUNT = 10000;

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        Object object = KeyPairGenerator.getInstance("RSA");
        ((KeyPairGenerator)object).initialize(3072);
        object = ((KeyPairGenerator)object).generateKeyPair();
        PublicKey publicKey = ((KeyPair)object).getPublic();
        PrivateKey privateKey = ((KeyPair)object).getPrivate();
        if (logFlag) {
            Driver.writeLog("\u516c\u94a5: " + publicKey.toString());
            Driver.writeLog("\u79c1\u94a5: " + privateKey);
        }
        return object;
    }

    public static byte[] encryptWithPrivateKey(byte[] object, byte[] byArray) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException {
        object = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec((byte[])object));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, (Key)object);
        object = cipher.doFinal(byArray);
        return object;
    }

    public static byte[] decryptWithPublicKey(byte[] object, byte[] byArray, String object2) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException {
        object = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec((byte[])object));
        object2 = Cipher.getInstance("RSA");
        ((Cipher)object2).init(2, (Key)object);
        object = ((Cipher)object2).doFinal(byArray);
        return object;
    }

    public static byte[] encryptKey_AES256_CBC_HMAC_SHA256(byte[] byArray, String string, byte[] byArray2) throws Exception {
        return EncryptionCommon.encryptKey_AES_CBC_HMAC_SHA256(byArray, string, byArray2, 256);
    }

    public static byte[] encryptKey_AES128_CBC_HMAC_SHA256(byte[] byArray, String string, byte[] byArray2) throws Exception {
        return EncryptionCommon.encryptKey_AES_CBC_HMAC_SHA256(byArray, string, byArray2, 128);
    }

    public static byte[] encryptKey_AES_CBC_HMAC_SHA256(byte[] byArray, String object, byte[] object2, int n2) throws Exception {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        object = new PBEKeySpec(((String)object).toCharArray(), (byte[])object2, 10000, n2);
        object = secretKeyFactory.generateSecret((KeySpec)object);
        object = new SecretKeySpec(object.getEncoded(), "AES");
        object2 = new IvParameterSpec((byte[])object2);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)object, (AlgorithmParameterSpec)object2);
        byArray = cipher.doFinal(byArray);
        return byArray;
    }

    public static byte[] decryptKey_AES256_CBC_HMAC_SHA256(byte[] byArray, String string, byte[] byArray2) throws Exception {
        return EncryptionCommon.decryptKey_AES_CBC_HMAC_SHA256(byArray, string, byArray2, 256);
    }

    public static byte[] decryptKey_AES128_CBC_HMAC_SHA256(byte[] byArray, String string, byte[] byArray2) throws Exception {
        return EncryptionCommon.decryptKey_AES_CBC_HMAC_SHA256(byArray, string, byArray2, 128);
    }

    public static byte[] decryptKey_AES_CBC_HMAC_SHA256(byte[] byArray, String object, byte[] object2, int n2) throws Exception {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        object = new PBEKeySpec(((String)object).toCharArray(), (byte[])object2, 10000, n2);
        object = secretKeyFactory.generateSecret((KeySpec)object);
        object = new SecretKeySpec(object.getEncoded(), "AES");
        object2 = new IvParameterSpec((byte[])object2);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)object, (AlgorithmParameterSpec)object2);
        byArray = cipher.doFinal(byArray);
        return byArray;
    }

    public static byte[] decryptKey(byte[] byArray, byte[] object, byte[] object2) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        object = new SecretKeySpec((byte[])object, "AES");
        object2 = new IvParameterSpec((byte[])object2);
        cipher.init(2, (Key)object, (AlgorithmParameterSpec)object2);
        byArray = cipher.doFinal(byArray);
        return byArray;
    }

    public static enum ColumnEncryptionAlgorithm {
        INVALID_ALGORITHM,
        AEAD_AES_256_CBC_HMAC_SHA256,
        AEAD_AES_128_CBC_HMAC_SHA256,
        SM4_SM3;

    }

    public static enum EncryptionType {
        DETERMINISTIC,
        NONE,
        RANDOMIZED;

    }

    public static enum CmkAlgorithm {
        INVALID_ALGORITHM,
        RSA_2048,
        AES_256_CBC,
        SM2,
        SM4,
        AES_256_GCM;

    }

    public static enum CmkKeyStore {
        INVALID_KEYSTORE,
        LOCALKMS;

    }
}

