/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.cluster;

import com.oscar.cluster.Node;
import com.oscar.cluster.Protocol;
import com.oscar.cluster.core.ClusterProtocol;
import com.oscar.core.BaseConnection;
import com.oscar.jdbc.OscarImportHandler;
import com.oscar.protocol.b.e;
import com.oscar.util.EscapeTools;
import java.io.Serializable;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cluster {
    private BaseConnection clusterConn;
    private Map<Integer, Node> nodeMap;
    private ClusterProtocol protocol;
    private ImportCredential importCredential = null;

    public Cluster(BaseConnection baseConnection) throws SQLException {
        this.clusterConn = baseConnection;
        this.protocol = new Protocol(baseConnection.getEncoding(), baseConnection);
        this.initNodes();
    }

    public void initNodes() throws SQLException {
        if (this.nodeMap == null) {
            this.nodeMap = new ConcurrentHashMap<Integer, Node>();
        }
        Cluster cluster = this;
        cluster.initNodesInfo(cluster.nodeMap);
        this.importCredential = this.getImportCredential();
    }

    public synchronized void reInit() throws SQLException {
        if (this.nodeMap == null || this.nodeMap.size() == 0) {
            this.initNodes();
            return;
        }
        Cluster cluster = this;
        synchronized (cluster) {
            HashMap<Integer, Node> hashMap = new HashMap<Integer, Node>();
            this.initNodesInfo(hashMap);
            for (Node node : this.nodeMap.values()) {
                Node node2 = Cluster.getNewNodeInNewMap(hashMap, node);
                if (node2 == null) {
                    if (!node.isOpen()) continue;
                    node.disConnect();
                    continue;
                }
                if (!node.isOpen()) continue;
                hashMap.put(node2.getNodeID(), node);
            }
            this.nodeMap.clear();
            this.nodeMap.putAll(hashMap);
            this.importCredential = this.getImportCredential();
            return;
        }
    }

    private static Node getNewNodeInNewMap(Map<Integer, Node> object, Node node) {
        for (Map.Entry entry : object.entrySet()) {
            Node node2 = (Node)entry.getValue();
            if (node2.getNodeID() != node.getNodeID() || !node2.getHost().equals(node.getHost()) || node2.getPort() != node.getPort()) continue;
            return (Node)entry.getValue();
        }
        return null;
    }

    protected void initNodesInfo(Map<Integer, Node> map) throws SQLException {
        Object object = "select * from get_import_info() as (\"NODEID\" INT2, \"PORT\" INT4, \"ADDRESS\" TEXT)";
        object = this.clusterConn.execSQL((String)object);
        while (object.next()) {
            int n2 = object.getInt("NODEID");
            int n3 = object.getInt("PORT");
            String string = object.getString("ADDRESS");
            Node node = new Node(n2, string, n3, this.clusterConn.getEncoding());
            map.put(n2, node);
        }
    }

    public ImportCredential getImportCredential() throws SQLException {
        Object object = "select get_import_identification_code()";
        object = this.clusterConn.execSQL((String)object);
        object.next();
        object = object.getArray(1);
        object = (Integer[])object.getArray();
        object = new ImportCredential(object[0], object[1]);
        return object;
    }

    public List<Node> getImportNodes(String object, String object2, int n2) throws SQLException {
        int n3;
        Object object3;
        Serializable serializable = new StringBuilder("select get_current_import_nodes('");
        if (object != null && !((String)object).isEmpty()) {
            object = EscapeTools.quotationWrapper(((String)object).replaceAll("'", "''"));
            ((StringBuilder)serializable).append((String)object).append(".");
        }
        ((StringBuilder)serializable).append(EscapeTools.quotationWrapper(((String)object2).replaceAll("'", "''")));
        ((StringBuilder)serializable).append("', ").append(n2).append(")");
        object = new ArrayList();
        object2 = this.clusterConn.execSQL(((StringBuilder)serializable).toString());
        while (object2.next()) {
            Array array = object2.getArray(1);
            serializable = (Integer[])array.getArray();
            object3 = serializable;
            n3 = ((Integer[])serializable).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = (Integer)object3[i2];
                object.add(n4);
            }
        }
        serializable = new ArrayList();
        do {
            n2 = 0;
            serializable.clear();
            object3 = object.iterator();
            while (object3.hasNext()) {
                n3 = (Integer)object3.next();
                Node node = this.nodeMap.get(n3);
                if (node != null) {
                    serializable.add(node);
                    continue;
                }
                this.reInit();
                n2 = 1;
            }
        } while (n2 != 0);
        return serializable;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Cluster [");
        stringBuilder.append("\n");
        stringBuilder.append("    nodeMap=[\n");
        for (Node node : this.nodeMap.values()) {
            stringBuilder.append("    ");
            stringBuilder.append(node.toString()).append("\n");
        }
        stringBuilder.append("    ]");
        stringBuilder.append("\n");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void importBegin(OscarImportHandler object) throws SQLException {
        String string = ((OscarImportHandler)object).getInsertBulkStr().toString();
        if ((object = ((OscarImportHandler)object).getHintParam()) != null) {
            string = string + " WITH " + (String)object;
        }
        object = this.clusterConn.getProtocol().a;
        e e2 = object;
        synchronized (object) {
            this.protocol.importBegin(string, object.b(), object.c());
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public int importEnd() throws SQLException {
        e e2;
        e e3 = e2 = this.clusterConn.getProtocol().a;
        synchronized (e2) {
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return this.protocol.importEnd(e2.b(), e2.c());
        }
    }

    public Map<Integer, Node> getNodeMap() {
        return this.nodeMap;
    }

    public void close() {
        if (this.nodeMap != null) {
            for (Node node : this.nodeMap.values()) {
                node.close();
            }
            this.nodeMap.clear();
        }
        this.nodeMap = null;
        this.clusterConn = null;
        this.protocol = null;
    }

    public ImportCredential getClusterImportCredential() throws SQLException {
        if (this.importCredential == null) {
            this.importCredential = this.getImportCredential();
        }
        return this.importCredential;
    }

    public void setClusterImportCredential(ImportCredential importCredential) {
        this.importCredential = importCredential;
    }

    static class ImportCredential {
        private int globalID;
        private int identificationCode;

        public ImportCredential(int n2, int n3) {
            this.globalID = n2;
            this.identificationCode = n3;
        }

        public int getGlobalID() {
            return this.globalID;
        }

        public int getIdentificationCode() {
            return this.identificationCode;
        }
    }
}

