/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.cluster;

import com.oscar.cluster.Cluster;
import com.oscar.cluster.INodeImportStream;
import com.oscar.cluster.Node;
import com.oscar.cluster.NodeImportStream;
import com.oscar.cluster.NodeImportStreamOverflow;
import com.oscar.cluster.RobinImportStrategy;
import com.oscar.cluster.core.ImportStrategy;
import com.oscar.core.BaseConnection;
import com.oscar.core.DistributeImportHandler;
import com.oscar.jdbc.OscarImportHandler;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ClusterImportHandler
extends OscarImportHandler
implements DistributeImportHandler {
    private Cluster cluster;
    private Cluster.ImportCredential importCredential;
    private List<Node> importNodes;
    private int importNodeConnectRetryTime;
    int nodenum = 0;
    protected volatile AtomicInteger rowCount = new AtomicInteger(0);
    private boolean hasBulk = false;
    private ImportStrategy strategy;
    private int executeBufferSize = 0x40000000;
    private boolean allowBufferOverflow = false;

    public ClusterImportHandler(BaseConnection baseConnection, String string, String string2) throws SQLException {
        super(baseConnection, string, string2);
        this.importNodeConnectRetryTime = baseConnection.getClusterImportNodeRetryTime();
        if (baseConnection.getCluster() == null) {
            baseConnection.setCluster(new Cluster(baseConnection));
        }
        this.cluster = baseConnection.getCluster();
        this.importCredential = this.cluster.getClusterImportCredential();
        this.strategy = new RobinImportStrategy();
        try {
            string = baseConnection.getConnectionProperties().getProperty("EXECUTEBUFFERSIZE");
            if (string != null && string.trim().length() > 0) {
                int n2 = Integer.parseInt(string);
                ((OscarImportHandler)this).setExecuteBufferSize(n2);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            String string3 = baseConnection.getConnectionProperties().getProperty("ENABLEBUFFEROVERFLOW");
            if (string3 != null && string3.trim().length() > 0) {
                this.allowBufferOverflow = Boolean.parseBoolean(string3);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public ClusterImportHandler(BaseConnection baseConnection, String string) throws SQLException {
        this(baseConnection, null, string);
    }

    public void reInit() throws SQLException {
        this.cluster.reInit();
        this.importCredential = this.cluster.getImportCredential();
        this.nodenum = 0;
    }

    @Override
    public void begin() throws SQLException {
        this.rowCount.set(0);
        this.isBegin = true;
        if (this.importStream == null) {
            if (this.allowBufferOverflow) {
                ClusterImportHandler clusterImportHandler = this;
                this.importStream = new NodeImportStreamOverflow(clusterImportHandler, clusterImportHandler.strategy);
                return;
            }
            ClusterImportHandler clusterImportHandler = this;
            this.importStream = new NodeImportStream(clusterImportHandler, clusterImportHandler.strategy);
            return;
        }
        ((INodeImportStream)((Object)this.importStream)).reStrategy(this.strategy);
        this.importStream.reInit();
    }

    @Override
    public void endRow() throws SQLException {
        try {
            super.endRow();
            this.rowCount.incrementAndGet();
        }
        catch (SQLException sQLException) {
            this.closeImportNodes();
            if (this.importStream != null && this.importStream.getThreadException() != null) {
                try {
                    this.cluster.importEnd();
                }
                catch (SQLException sQLException2) {}
            }
            throw sQLException;
        }
        if (this.importStream.needExecute()) {
            this.doExecute();
        }
    }

    public void closeImportNodes() {
        if (this.importNodes != null) {
            for (Node node : this.importNodes) {
                node.disConnect();
            }
            this.importNodes.clear();
            this.importNodes = null;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.hasRowNotSubmitted()) {
            ((OscarImportHandler)this).endRow();
        }
        this.doExecute();
        return true;
    }

    private void doExecute() throws SQLException {
        if (this.isBegin()) {
            try {
                boolean bl = true;
                try {
                    super.endExecute();
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = sQLException;
                    if (sQLException.getErrorCode() == 1001) {
                        bl = false;
                    }
                    throw sQLException2;
                }
                if (bl) {
                    for (Node node : this.importNodes) {
                        node.importEnd();
                    }
                }
                int n2 = this.cluster.importEnd();
                this.setCurrentUpdateCount(n2);
                this.hasBulk = false;
                long l2 = this.getUpdateCount();
                if (l2 <= 0L) {
                    this.setUpdateCount(n2);
                    return;
                }
                this.setUpdateCount((long)n2 + l2);
            }
            catch (SQLException sQLException) {
                this.closeImportNodes();
                this.importCredential = null;
                this.cluster.setClusterImportCredential(null);
                this.hasBulk = false;
                throw sQLException;
            }
        }
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.importNodes != null) {
            this.importNodes.clear();
        }
        this.importNodes = null;
        this.importCredential = null;
    }

    @Override
    public void setNodeNum(int n2) throws SQLException {
        if (n2 > this.cluster.getNodeMap().size()) {
            throw new SQLException("\u8282\u70b9\u6570\u91cf\u8fc7\u5927, \u5f53\u524d\u8282\u70b9\u6570" + this.cluster.getNodeMap().size());
        }
        this.nodenum = n2;
    }

    protected void initImportNodes() throws SQLException {
        boolean bl;
        this.importNodes = this.cluster.getImportNodes(this.schemName, this.tableName, this.nodenum);
        int n2 = 0;
        do {
            try {
                if (this.importCredential == null) {
                    this.importCredential = this.cluster.getClusterImportCredential();
                }
                for (Node node : this.importNodes) {
                    node.connect(this.importCredential);
                }
                bl = true;
            }
            catch (Exception exception) {
                this.closeImportNodes();
                bl = false;
                if (n2 >= this.importNodeConnectRetryTime) continue;
                this.reInit();
            }
        } while (!bl && n2++ < this.importNodeConnectRetryTime);
        if (!bl) {
            throw new SQLException("\u8282\u70b9\u8fde\u63a5\u521b\u5efa\u5931\u8d25\uff0c\u5c1d\u8bd5\u6b21\u6570" + (this.importNodeConnectRetryTime + 1));
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public boolean isHasBulk() {
        return this.hasBulk;
    }

    public void setHasBulk(boolean bl) {
        this.hasBulk = bl;
    }

    public List<Node> getImportNodes() {
        return this.importNodes;
    }

    public int getExecuteBufferSize() {
        return this.executeBufferSize;
    }

    @Override
    public void setExecuteBufferSize(int n2) {
        if (n2 <= 0) {
            this.executeBufferSize = 0;
            return;
        }
        this.executeBufferSize = n2 << 10 << 10;
    }
}

