/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.cluster;

import com.oscar.Driver;
import com.oscar.cluster.ClusterImportHandler;
import com.oscar.cluster.INodeImportStream;
import com.oscar.cluster.core.DataImportStream;
import com.oscar.cluster.core.ImportStrategy;
import com.oscar.util.OSQLException;
import com.oscar.util.ShareImportStream1;
import java.sql.SQLException;

public class NodeImportStream
extends ShareImportStream1
implements INodeImportStream {
    private ImportStrategy strategy;
    private ClusterImportHandler handler;
    private volatile long sendSizeBeforeExecute;

    public NodeImportStream(ClusterImportHandler clusterImportHandler, ImportStrategy importStrategy) {
        super(clusterImportHandler);
        this.handler = clusterImportHandler;
        this.strategy = importStrategy;
    }

    @Override
    public synchronized byte[] getMessage() {
        byte[] byArray = super.getMessage();
        if (byArray != null) {
            this.sendSizeBeforeExecute += (long)byArray.length;
        }
        return byArray;
    }

    @Override
    public void sendMessage(byte[] byArray) throws SQLException {
        if (!this.handler.isHasBulk()) {
            try {
                Driver.writeLog("new modify import node and bulk together");
                this.handler.initImportNodes();
                this.strategy.setImportNodes(this.handler.getImportNodes());
                this.handler.getCluster().importBegin(this.handler);
            }
            catch (SQLException sQLException) {
                this.handler.closeImportNodes();
                throw sQLException;
            }
            this.handler.setHasBulk(true);
        }
        DataImportStream dataImportStream = this.handler.rowCount.get() >= 10000 ? this.strategy.nextStream() : this.strategy.currentStream();
        try {
            dataImportStream.importData(byArray);
        }
        catch (SQLException sQLException) {
            this.handler.closeImportNodes();
            if (sQLException.getMessage() != null && sQLException.getMessage().contains("From JDBC:")) {
                throw sQLException;
            }
            throw new OSQLException("OSCAR-01001", sQLException.getSQLState(), 1001);
        }
        this.handler.rowCount.set(0);
    }

    @Override
    public void reStrategy(ImportStrategy importStrategy) {
        this.strategy = importStrategy;
    }

    @Override
    public void finished() {
        super.finished();
        this.sendSizeBeforeExecute = 0L;
    }

    @Override
    public boolean needExecute() {
        if (this.handler.getExecuteBufferSize() > 0) {
            return this.sendSizeBeforeExecute + (long)this.position >= (long)this.handler.getExecuteBufferSize();
        }
        return false;
    }
}

