/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.copy;

import com.oscar.copy.CopyOut;
import com.oscar.core.BaseStatement;
import com.oscar.jdbc.OscarResultSet;
import com.oscar.jdbc.OscarStatement;
import com.oscar.util.CommandAnalyse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CopyOutImpl
implements CopyOut {
    private String querySql;
    private byte[] colSepByte;
    private byte[] rowSepByte;
    private char escapeChar = (char)34;
    private byte[] nullValue;
    private char escapeCharCommon = (char)92;
    private boolean isBackup = false;
    private boolean isCsv = false;
    private ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
    private byte[] columnBuffer = new byte[16384];
    private int colPosition = 0;
    private ResultSet rs;
    private PreparedStatement pstmt;
    private Statement stmt;
    private boolean initResultSet = false;
    private int columnCount = 0;
    private byte[] backupMetaData;
    private byte[] backupPhysicalData;
    private int dataKind;
    private byte[] currentRow;

    public CopyOutImpl(Connection connection, String string, String string2, String string3, int n2, int n3, int n4, int[] nArray) throws SQLException {
        this(connection, string, string2, string3, n2);
        this.dataKind = n3;
        switch (n3) {
            case 1: {
                ((BaseStatement)((Object)this.pstmt)).setBuckets(n4);
                ((BaseStatement)((Object)this.pstmt)).setHashColIds(nArray);
            }
        }
    }

    public CopyOutImpl(Connection connection, String object, String object2, String string, int n2) throws SQLException {
        this.colSepByte = ((String)object2).getBytes();
        this.rowSepByte = string.getBytes();
        object2 = CommandAnalyse.analyseNullValue((String)object);
        this.nullValue = ((String)object2).getBytes();
        this.querySql = CommandAnalyse.analyseQuery((String)object);
        byte[] byArray = CommandAnalyse.analyseColSep((String)object);
        object2 = byArray;
        if (byArray != null) {
            this.colSepByte = (byte[])object2;
        }
        if (!((String)(object = CommandAnalyse.analyseEscapeChar((String)object))).equals("") && object != null) {
            object = ((String)object).getBytes();
            this.escapeChar = (char)object[0];
            this.isCsv = true;
        }
        this.pstmt = connection.prepareStatement(this.querySql);
        this.pstmt.setFetchSize(n2);
    }

    public CopyOutImpl(Connection connection, String string, String string2, String string3) throws SQLException {
        this(connection, string, string2, string3, 0);
    }

    public CopyOutImpl(Connection object, String string) throws SQLException {
        this.querySql = CommandAnalyse.analyseQuery(string);
        this.stmt = object.createStatement();
        byte[] byArray = ((OscarStatement)this.stmt).backupKstore(this.querySql);
        object = byArray;
        if (byArray != null) {
            this.backupMetaData = (byte[])object;
        }
        this.setIsBackup(true);
    }

    @Override
    public synchronized void cancelCopy() throws SQLException {
        this.columnBuffer = null;
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.pstmt != null) {
            this.pstmt.cancel();
            this.pstmt.close();
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getFieldCount() throws SQLException {
        PreparedStatement preparedStatement = this.pstmt;
        synchronized (preparedStatement) {
            if (!this.initResultSet) {
                this.initResultSet = true;
                try {
                    this.rs = this.pstmt.executeQuery();
                    if (this.rs == null) return this.columnCount;
                    this.columnCount = this.rs.getMetaData().getColumnCount();
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2 = sQLException;
                    throw sQLException;
                }
            } else {
                if (this.rs != null) return this.columnCount;
                throw new SQLException("canceled");
            }
            return this.columnCount;
        }
    }

    @Override
    public byte[] readFromCopy() throws SQLException {
        switch (this.dataKind) {
            case 1: {
                PreparedStatement preparedStatement = this.pstmt;
                synchronized (preparedStatement) {
                    if (!this.initResultSet) {
                        this.initResultSet = true;
                        try {
                            this.rs = this.pstmt.executeQuery();
                            this.columnCount = this.rs.getMetaData().getColumnCount();
                        }
                        catch (SQLException sQLException) {
                            SQLException sQLException2 = sQLException;
                            throw sQLException;
                        }
                    } else if (this.rs == null) {
                        throw new SQLException("canceled");
                    }
                    this.currentRow = (byte[])(this.rs.next() ? ((OscarResultSet)this.rs).getCurrentBlock() : null);
                }
                return this.currentRow;
            }
            case 2: {
                if (this.getBackUpMetadata() != null) {
                    this.backupPhysicalData = this.getNextBackUpPhysicalRowData();
                    return this.backupPhysicalData;
                }
                return null;
            }
        }
        PreparedStatement preparedStatement = this.pstmt;
        synchronized (preparedStatement) {
            if (!this.initResultSet) {
                this.initResultSet = true;
                try {
                    this.rs = this.pstmt.executeQuery();
                    this.columnCount = this.rs.getMetaData().getColumnCount();
                }
                catch (SQLException sQLException) {
                    SQLException sQLException3 = sQLException;
                    throw sQLException;
                }
            } else if (this.rs == null) {
                throw new SQLException("canceled");
            }
        }
        if (this.isCsv) {
            return this.readFromCopyCsv();
        }
        return this.readFromCopyCommon();
    }

    private synchronized byte[] readFromCopyCsv() throws SQLException {
        if (this.rs != null && this.rs.next()) {
            try {
                byte[][] byArray = ((OscarResultSet)this.rs).getCurrentRow();
                boolean bl = false;
                boolean bl2 = false;
                int n2 = byArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (byArray[i2] != null) {
                        int n3 = byArray[i2].length;
                        for (int i3 = 0; i3 < n3; ++i3) {
                            int n4;
                            if (byArray[i2][i3] == this.escapeChar) {
                                bl = true;
                                this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                continue;
                            }
                            int n5 = i3;
                            if (bl) {
                                this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                continue;
                            }
                            if (n3 - i3 >= this.colSepByte.length) {
                                n4 = 0;
                                while (n4 < this.colSepByte.length) {
                                    if (this.colSepByte[n4] != byArray[i2][i3]) {
                                        i3 = n5;
                                        break;
                                    }
                                    if (n4 == this.colSepByte.length - 1) {
                                        bl2 = true;
                                        bl = true;
                                        break;
                                    }
                                    ++n4;
                                    ++i3;
                                }
                            }
                            if (!bl2 && n3 - i3 >= this.rowSepByte.length) {
                                n4 = 0;
                                while (n4 < this.rowSepByte.length) {
                                    if (this.rowSepByte[n4] != byArray[i2][i3]) {
                                        i3 = n5;
                                        break;
                                    }
                                    if (n4 == this.rowSepByte.length - 1) {
                                        bl = true;
                                        break;
                                    }
                                    ++n4;
                                    ++i3;
                                }
                            }
                            if (n5 == i3) {
                                this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                continue;
                            }
                            System.arraycopy(byArray[i2], n5, this.columnBuffer, this.colPosition, i3 - n5 + 1);
                        }
                        if (bl) {
                            CopyOutImpl copyOutImpl = this;
                            copyOutImpl.writeColumn2(copyOutImpl.columnBuffer, 0, this.colPosition);
                        } else {
                            CopyOutImpl copyOutImpl = this;
                            copyOutImpl.writeColumn(copyOutImpl.columnBuffer, 0, this.colPosition);
                        }
                        this.colPosition = 0;
                        bl2 = false;
                        bl = false;
                    }
                    if (i2 >= n2 - 1) continue;
                    this.nextColumnByte();
                }
                this.nextRowByte();
                this.flush();
                byte[] byArray2 = this.out.toByteArray();
                return byArray2;
            }
            catch (IOException iOException) {
                throw new SQLException("IOException occured!");
            }
            finally {
                this.out.reset();
            }
        }
        return null;
    }

    private synchronized byte[] readFromCopyCommon() throws SQLException {
        if (this.rs != null && this.rs.next()) {
            try {
                byte[][] byArray = ((OscarResultSet)this.rs).getCurrentRow();
                int n2 = byArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3;
                    if (byArray[i2] != null) {
                        n3 = byArray[i2].length;
                        block6: for (int i3 = 0; i3 < n3; ++i3) {
                            int n4;
                            if (byArray[i2][i3] == this.escapeCharCommon) {
                                if (i3 != n3 - 1) {
                                    if (byArray[i2][i3 + 1] == this.escapeCharCommon) {
                                        this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                        this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                        continue;
                                    }
                                    for (n4 = 0; n4 < this.colSepByte.length; ++n4) {
                                        if (byArray[i2][i3 + 1] == this.colSepByte[n4]) {
                                            this.columnBuffer[this.colPosition++] = (byte)this.escapeCharCommon;
                                            this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                            continue block6;
                                        }
                                        if (n4 != this.colSepByte.length - 1) continue;
                                        this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                    }
                                    continue;
                                }
                                if (i2 != n2 - 1) {
                                    this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                    this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                    continue;
                                }
                                this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                continue;
                            }
                            for (n4 = 0; n4 < this.colSepByte.length; ++n4) {
                                if (byArray[i2][i3] == this.colSepByte[n4]) {
                                    this.columnBuffer[this.colPosition++] = (byte)this.escapeCharCommon;
                                    this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                                    continue block6;
                                }
                                if (n4 != this.colSepByte.length - 1) continue;
                                this.columnBuffer[this.colPosition++] = byArray[i2][i3];
                            }
                        }
                        CopyOutImpl copyOutImpl = this;
                        copyOutImpl.writeColumn(copyOutImpl.columnBuffer, 0, this.colPosition);
                        this.colPosition = 0;
                    } else {
                        for (n3 = 0; n3 < this.nullValue.length; ++n3) {
                            this.columnBuffer[this.colPosition++] = this.nullValue[n3];
                        }
                        CopyOutImpl copyOutImpl = this;
                        copyOutImpl.writeColumn(copyOutImpl.columnBuffer, 0, this.colPosition);
                        this.colPosition = 0;
                    }
                    if (i2 >= n2 - 1) continue;
                    this.nextColumnByte();
                }
                this.nextRowByte();
                this.flush();
                byte[] byArray2 = this.out.toByteArray();
                return byArray2;
            }
            catch (IOException iOException) {
                throw new SQLException("IOException occured!");
            }
            finally {
                this.out.reset();
            }
        }
        return null;
    }

    public void writeColumn(byte by) throws IOException {
        this.out.write(by);
    }

    public void writeColumn(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.out.write(byArray);
        }
    }

    public void writeColumn(byte[] byArray, int n2, int n3) {
        if (byArray != null) {
            this.out.write(byArray, n2, n3);
        }
    }

    public void writeColumn2(byte[] byArray, int n2, int n3) {
        if (byArray != null) {
            this.out.write((byte)this.escapeChar);
            this.out.write(byArray, n2, n3);
            this.out.write((byte)this.escapeChar);
        }
    }

    public void nextColumnByte() throws IOException {
        this.out.write(this.colSepByte);
    }

    public void nextRowByte() throws IOException {
        this.out.write(this.rowSepByte);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void setIsBackup(boolean bl) {
        this.isBackup = bl;
    }

    @Override
    public boolean isBackup() {
        return this.isBackup;
    }

    @Override
    public byte[] getBackUpMetadata() {
        return this.backupMetaData;
    }

    public byte[] getBackUpPhysicalRowData() {
        return this.backupPhysicalData;
    }

    public byte[] getNextBackUpPhysicalRowData() throws SQLException {
        return ((OscarStatement)this.stmt).getNextPhysicalDataRow();
    }

    @Override
    public int getKind() {
        return this.dataKind;
    }

    @Override
    public byte[] getHash() throws SQLException {
        byte[] byArray = new byte[4];
        System.arraycopy(this.currentRow, 0, byArray, 0, 4);
        return byArray;
    }

    @Override
    public int getHashIntValue() throws SQLException {
        byte[] byArray = new byte[4];
        System.arraycopy(this.currentRow, 0, byArray, 0, 4);
        return this.convertByteToInt(byArray);
    }

    @Override
    public byte[] getCurrentBlockData() throws SQLException {
        return this.currentRow;
    }

    private int convertByteToInt(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            n2 = n3 | n2 << 8;
        }
        return n2;
    }
}

