/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.core;

import com.oscar.Config;
import com.oscar.Driver;
import com.oscar.util.OSQLException;
import com.oscar.util.converter.CharacterSetByte;
import com.oscar.util.converter.CharacterSetUTF;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Hashtable;

public class Encoding {
    public static final Integer PG_SQL_ASCII = 0;
    public static final Integer PG_WIN1252 = 1;
    public static final Integer PG_BIG5 = 29;
    public static final Integer PG_GBK = 30;
    public static final Integer PG_UTF8 = 6;
    public static final Integer PG_UCS2 = 6;
    public static final Integer PG_GB18030 = 33;
    public static final Integer PG_UNICODE = 34;
    public static final Integer PG_ISO88591 = 8;
    private boolean logFlag = Driver.getLogLevel() >= 3;
    private static final Hashtable<String, Integer> encodings = new Hashtable<String, Integer>();
    private static final Hashtable<Integer, String> encodingCodes;
    private static final Hashtable<String, String> encodingNameMap;
    private static final Encoding DEFAULT_ENCODING;
    private static final Encoding SYSTEM_ENCODING;
    private String encoding;
    private final boolean fastASCIINumbers;

    public int getEncodingType() {
        if (encodings.get(this.encoding) == null) {
            if (this.logFlag) {
                Driver.writeLog("clientEncoding:" + this.encoding + ",jdbc not support");
            }
            return -1;
        }
        return encodings.get(this.encoding);
    }

    protected Encoding() {
        this.encoding = Config.ENCODING;
        if (!Encoding.JVMisAvailable(this.encoding) && this.encoding.equals("GB18030")) {
            this.encoding = "GBK";
        }
        this.fastASCIINumbers = this.testAsciiNumbers();
    }

    protected Encoding(String string) {
        this.encoding = string;
        this.fastASCIINumbers = this.testAsciiNumbers();
    }

    public static Encoding getEncoding(String string) {
        if (string != null) {
            if ("UTF8".equalsIgnoreCase(string) || "UTF-8".equalsIgnoreCase(string)) {
                return new CharacterSetUTF();
            }
            if ("ASCII".equalsIgnoreCase(string)) {
                return new CharacterSetByte();
            }
        }
        if (string != null && Encoding.OSCARisAvailable(string)) {
            return new Encoding(encodingNameMap.get(string));
        }
        if (Encoding.SYSTEM_ENCODING.encoding != null) {
            return SYSTEM_ENCODING;
        }
        return DEFAULT_ENCODING;
    }

    public static Encoding getEncoding(Integer n2) throws UnsupportedEncodingException {
        if (n2.intValue() == PG_SQL_ASCII.intValue()) {
            return SYSTEM_ENCODING;
        }
        String string = encodingCodes.get(n2);
        if (string != null) {
            return new Encoding(string);
        }
        if (n2.intValue() == PG_UNICODE.intValue()) {
            return new Encoding(encodingCodes.get(PG_UTF8));
        }
        throw new UnsupportedEncodingException("OSCAR-00903");
    }

    public byte[] encode(String string) throws SQLException {
        byte[] byArray = null;
        try {
            if (string != null) {
                byArray = string.getBytes(this.encoding);
            }
            if (byArray == null) {
                byArray = new byte[]{};
            }
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OSQLException("OSCAR-00001", "88888", 1);
        }
    }

    public String decode(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            return new String(byArray, n2, n3, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OSQLException("OSCAR-00001", "88888", 1);
        }
    }

    public String decode(byte[] byArray) throws SQLException {
        return this.decode(byArray, 0, byArray.length);
    }

    public static Encoding defaultEncoding() {
        return DEFAULT_ENCODING;
    }

    private static boolean OSCARisAvailable(String string) {
        if (encodingNameMap.get(string) != null) {
            try {
                "DUMMY".getBytes(encodingNameMap.get(string));
                return true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return false;
            }
        }
        return false;
    }

    private static boolean JVMisAvailable(String string) {
        if (encodings.get(string) != null) {
            try {
                "DUMMY".getBytes(string);
                return true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return false;
            }
        }
        return false;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private boolean testAsciiNumbers() {
        try {
            String string = "-0123456789";
            Object object = this.encode(string);
            object = new String((byte[])object, "US-ASCII");
            return string.equals(object);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean hasAsciiNumbers() {
        return this.fastASCIINumbers;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Encoding) {
            return this.encoding.equalsIgnoreCase(((Encoding)object).getEncoding());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    static {
        encodings.put("ASCII", PG_SQL_ASCII);
        encodings.put("windows-1252", PG_WIN1252);
        encodings.put("BIG5", PG_BIG5);
        encodings.put("GBK", PG_GBK);
        encodings.put("GB2312", PG_GBK);
        encodings.put("UTF8", PG_UTF8);
        encodings.put("UTF-8", PG_UTF8);
        encodings.put("GB18030", PG_GB18030);
        encodings.put("ISO-8859-1", PG_ISO88591);
        encodingCodes = new Hashtable<Integer, String>();
        encodingCodes.put(PG_SQL_ASCII, "ASCII");
        encodingCodes.put(PG_WIN1252, "windows-1252");
        encodingCodes.put(PG_BIG5, "BIG5");
        encodingCodes.put(PG_GBK, "GBK");
        encodingCodes.put(PG_UTF8, "UTF8");
        encodingCodes.put(PG_GB18030, "GB18030");
        encodingNameMap = new Hashtable<String, String>();
        encodingNameMap.put("ASCII", "ASCII");
        encodingNameMap.put("WIN1252", "windows-1252");
        encodingNameMap.put("BIG5", "BIG5");
        encodingNameMap.put("GBK", "GBK");
        encodingNameMap.put("GB2312", "GBK");
        encodingNameMap.put("UTF8", "UTF8");
        encodingNameMap.put("UTF-8", "UTF8");
        encodingNameMap.put("UCS2", "UTF8");
        encodingNameMap.put("GB18030", "GB18030");
        DEFAULT_ENCODING = new Encoding("UTF8");
        SYSTEM_ENCODING = new Encoding();
    }
}

