/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.core;

import com.oscar.core.BaseConnection;
import com.oscar.core.Encoding;
import com.oscar.core.FieldMetadata;
import java.sql.SQLException;

public class Field {
    private int length;
    private int oid;
    private int mod;
    private String name;
    private String aliasName;
    private int nullable = 1;
    private boolean updatable = true;
    private String tableName;
    private String schemaName;
    private byte[] nameByte;
    private byte[] aliasNameByte;
    private byte[] tableNameByte;
    private byte[] schemaNameByte;
    private int oscarType = -1;
    private BaseConnection conn;
    protected Encoding encoding;
    protected Encoding clientEncoding;
    protected boolean encodingFlag = false;
    private FieldMetadata metadata;
    private int columnNameCase = 0;
    private static final int COLUMN_UPPER = 1;
    private static final int COLUMN_LOWER = 2;
    private int columnDecTypeOid = 0;
    private byte[] columnEncryptKeyModeBytes;
    private int columnEncryptMode;
    private byte[] columnEncryptTypeBytes;
    private byte[] columnEncryptKeyValueBytes;
    private byte[] columnMasterKeyPathBytes;
    private boolean fullEncrypted;

    public Field() {
    }

    public Field(BaseConnection baseConnection, String string, int n2, int n3, int n4, String string2, String string3, String string4, byte by) {
        this.conn = baseConnection;
        this.name = string;
        this.oid = n2;
        this.length = n3;
        this.mod = n4;
        this.tableName = string3;
        this.aliasName = string2;
        this.schemaName = string4;
        this.encoding = baseConnection.getEncoding();
        this.clientEncoding = baseConnection.getClientEncoding();
        this.encodingFlag = this.encoding == null ? true : this.encoding.equals(this.clientEncoding);
        if ((by & 0x40) == 0) {
            this.updatable = false;
        }
        if ((by & 0x80) == 0) {
            this.nullable = 0;
        }
        this.columnNameCase = Integer.parseInt(baseConnection.getConnectionProperties().getProperty("COLUMNNAMECASE", "0"));
    }

    public Field(BaseConnection baseConnection, byte[] byArray, int n2, int n3, int n4, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte by) {
        this.conn = baseConnection;
        this.nameByte = byArray;
        this.oid = n2;
        this.length = n3;
        this.mod = n4;
        this.tableNameByte = byArray3;
        this.aliasNameByte = byArray2;
        this.schemaNameByte = byArray4;
        this.encoding = baseConnection.getEncoding();
        this.clientEncoding = baseConnection.getClientEncoding();
        this.encodingFlag = this.encoding == null ? true : this.encoding.equals(this.clientEncoding);
        if ((by & 0x40) == 0) {
            this.updatable = false;
        }
        if ((by & 0x80) == 0) {
            this.nullable = 0;
        }
        if (byArray3 == null || byArray3.length == 0) {
            this.metadata = new FieldMetadata(this.getAliasName());
        }
        this.columnNameCase = Integer.parseInt(baseConnection.getConnectionProperties().getProperty("COLUMNNAMECASE", "0"));
    }

    public Field(BaseConnection baseConnection, String string, int n2, int n3) {
        this.conn = baseConnection;
        this.name = string;
        this.oid = n2;
        this.length = n3;
        this.encoding = baseConnection.getEncoding();
        this.clientEncoding = baseConnection.getClientEncoding();
        this.encodingFlag = this.encoding == null ? true : this.encoding.equals(this.clientEncoding);
        this.columnNameCase = Integer.parseInt(baseConnection.getConnectionProperties().getProperty("COLUMNNAMECASE", "0"));
    }

    public Field(BaseConnection baseConnection, String string, int n2, int n3, String string2) {
        this(baseConnection, string, n2, n3);
        this.aliasName = string2;
    }

    public int getOID() {
        return this.oid;
    }

    public void setOID(int n2) {
        this.oid = n2;
    }

    public int getMod() {
        return this.mod;
    }

    public String getName() {
        if (this.name == null && this.nameByte != null) {
            try {
                this.name = this.encodingFlag ? this.clientEncoding.decode(this.nameByte) : this.encoding.decode(this.nameByte);
            }
            catch (SQLException sQLException) {
                throw new Error(sQLException);
            }
        }
        return this.name;
    }

    public String getNameCase() {
        String string = this.getName();
        if (this.columnNameCase == 1) {
            return string.toUpperCase();
        }
        if (this.columnNameCase == 2) {
            return string.toLowerCase();
        }
        return string;
    }

    public void resetName() {
        this.name = this.getAliasName();
    }

    public String getAliasName() {
        if (this.aliasName == null && this.aliasNameByte != null) {
            try {
                this.aliasName = this.encodingFlag ? this.clientEncoding.decode(this.aliasNameByte) : this.encoding.decode(this.aliasNameByte);
            }
            catch (SQLException sQLException) {
                throw new Error(sQLException);
            }
        }
        return this.aliasName;
    }

    public String getAliasNameCase() {
        String string = this.getAliasName();
        if (this.columnNameCase == 1) {
            return string.toUpperCase();
        }
        if (this.columnNameCase == 2) {
            return string.toLowerCase();
        }
        return string;
    }

    public int getLength() {
        return this.length;
    }

    public String getDBType() throws SQLException {
        if (this.fullEncrypted) {
            return this.conn.getDBType(this.columnDecTypeOid);
        }
        return this.conn.getDBType(this.oid);
    }

    public int getSQLType() throws SQLException {
        if (this.fullEncrypted) {
            return this.conn.getSQLType(this.columnDecTypeOid);
        }
        return this.conn.getSQLType(this.oid);
    }

    public int getOscarType() throws SQLException {
        if (this.oscarType == -1) {
            if (this.fullEncrypted) {
                return this.conn.getOscarType(this.columnDecTypeOid);
            }
            return this.conn.getOscarType(this.oid);
        }
        return this.oscarType;
    }

    public int isNullable() {
        return this.nullable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public String getSchemaName() {
        if (this.schemaName == null && this.schemaNameByte != null) {
            try {
                this.schemaName = this.encodingFlag ? this.clientEncoding.decode(this.schemaNameByte) : this.encoding.decode(this.schemaNameByte);
            }
            catch (SQLException sQLException) {
                throw new Error(sQLException);
            }
        }
        return this.schemaName;
    }

    public String getTableName() {
        if (this.tableName == null && this.tableNameByte != null) {
            try {
                this.tableName = this.encodingFlag ? this.clientEncoding.decode(this.tableNameByte) : this.encoding.decode(this.tableNameByte);
            }
            catch (SQLException sQLException) {
                throw new Error(sQLException);
            }
        }
        return this.tableName;
    }

    public FieldMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(FieldMetadata fieldMetadata) {
        this.metadata = fieldMetadata;
    }

    public int getColumnDecTypeOid() {
        return this.columnDecTypeOid;
    }

    public void setColumnDecTypeOid(int n2) {
        this.columnDecTypeOid = n2;
    }

    public String getColumnEncryptKeyMode() {
        try {
            if (this.encodingFlag) {
                return this.clientEncoding.decode(this.columnEncryptKeyModeBytes);
            }
            return this.encoding.decode(this.columnEncryptKeyModeBytes);
        }
        catch (SQLException sQLException) {
            throw new Error(sQLException);
        }
    }

    public void setColumnEncryptKeyModeBytes(byte[] byArray) {
        this.columnEncryptKeyModeBytes = byArray;
    }

    public int getColumnEncryptMode() {
        return this.columnEncryptMode;
    }

    public void setColumnEncryptMode(int n2) {
        this.columnEncryptMode = n2;
    }

    public String getColumnEncryptType() {
        try {
            if (this.encodingFlag) {
                return this.clientEncoding.decode(this.columnEncryptTypeBytes);
            }
            return this.encoding.decode(this.columnEncryptTypeBytes);
        }
        catch (SQLException sQLException) {
            throw new Error(sQLException);
        }
    }

    public void setColumnEncryptTypeBytes(byte[] byArray) {
        this.columnEncryptTypeBytes = byArray;
    }

    public String getColumnEncryptKeyValue() {
        try {
            if (this.encodingFlag) {
                return this.clientEncoding.decode(this.columnEncryptKeyValueBytes);
            }
            return this.encoding.decode(this.columnEncryptKeyValueBytes);
        }
        catch (SQLException sQLException) {
            throw new Error(sQLException);
        }
    }

    public void setColumnEncryptKeyValueBytes(byte[] byArray) {
        this.columnEncryptKeyValueBytes = byArray;
    }

    public String getColumnMasterKeyPath() {
        try {
            if (this.encodingFlag) {
                return this.clientEncoding.decode(this.columnMasterKeyPathBytes);
            }
            return this.encoding.decode(this.columnMasterKeyPathBytes);
        }
        catch (SQLException sQLException) {
            throw new Error(sQLException);
        }
    }

    public void setColumnMasterKeyPathBytes(byte[] byArray) {
        this.columnMasterKeyPathBytes = byArray;
    }

    public void setFullEncrypted(boolean bl) {
        this.fullEncrypted = bl;
    }
}

