/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarBox
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8909836498867598265L;
    private OscarPoint[] point = new OscarPoint[2];

    public OscarBox(double d2, double d3, double d4, double d5) {
        this();
        this.point[0] = new OscarPoint(d2, d3);
        this.point[1] = new OscarPoint(d4, d5);
    }

    public OscarBox(OscarPoint oscarPoint, OscarPoint oscarPoint2) {
        this();
        this.point[0] = oscarPoint;
        this.point[1] = oscarPoint2;
    }

    public OscarBox(String string) throws SQLException {
        this();
        ((OscarObject)this).setValue(string);
    }

    public OscarBox() {
        this.setType("box");
    }

    @Override
    public void setValue(String string) throws SQLException {
        OscarTokenizer oscarTokenizer = new OscarTokenizer(string, ',');
        if (oscarTokenizer.getSize() != 2) {
            throw new SQLException("Conversion to type + " + this.type + " failed: " + string);
        }
        this.point[0] = new OscarPoint(oscarTokenizer.getToken(0));
        this.point[1] = new OscarPoint(oscarTokenizer.getToken(1));
    }

    public void setByteValue(byte[] byArray, int n2) {
        this.point[0] = new OscarPoint();
        this.point[0].setByteValue(byArray, n2);
        this.point[1] = new OscarPoint();
        this.point[1].setByteValue(byArray, n2 + this.point[0].lengthInBytes());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OscarBox) {
            object = (OscarBox)object;
            if (((OscarObject)((OscarBox)object).point[0]).equals(this.point[0]) && ((OscarObject)((OscarBox)object).point[1]).equals(this.point[1])) {
                return true;
            }
            if (((OscarObject)((OscarBox)object).point[0]).equals(this.point[1]) && ((OscarObject)((OscarBox)object).point[1]).equals(this.point[0])) {
                return true;
            }
            if (((OscarBox)object).point[0].x == this.point[0].x && ((OscarBox)object).point[0].y == this.point[1].y && ((OscarBox)object).point[1].x == this.point[1].x && ((OscarBox)object).point[1].y == this.point[0].y) {
                return true;
            }
            if (((OscarBox)object).point[0].x == this.point[1].x && ((OscarBox)object).point[0].y == this.point[0].y && ((OscarBox)object).point[1].x == this.point[0].x && ((OscarBox)object).point[1].y == this.point[1].y) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((OscarObject)this.point[0]).hashCode() ^ ((OscarObject)this.point[1]).hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OscarBox oscarBox = (OscarBox)super.clone();
        if (oscarBox.point != null) {
            oscarBox.point = (OscarPoint[])oscarBox.point.clone();
            for (int i2 = 0; i2 < oscarBox.point.length; ++i2) {
                if (oscarBox.point[i2] == null) continue;
                oscarBox.point[i2] = (OscarPoint)oscarBox.point[i2].clone();
            }
        }
        return oscarBox;
    }

    @Override
    public String getValue() {
        return this.point[0].toString() + "," + this.point[1].toString();
    }

    public int lengthInBytes() {
        return this.point[0].lengthInBytes() + this.point[1].lengthInBytes();
    }

    public void toBytes(byte[] byArray, int n2) {
        this.point[0].toBytes(byArray, n2);
        this.point[1].toBytes(byArray, n2 + this.point[0].lengthInBytes());
    }
}

