/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.util.Geometry;
import com.oscar.gis.util.GeometryBuilder;
import com.oscar.gis.util.GeometryTokenizer;
import com.oscar.gis.util.Point;
import java.sql.SQLException;

public abstract class OscarBoxbase
extends OscarObject {
    private static final long serialVersionUID = 256L;
    protected Point llb;
    protected Point urt;

    public abstract String getPrefix();

    public abstract String getOscartype();

    public OscarBoxbase() {
        OscarBoxbase oscarBoxbase = this;
        oscarBoxbase.setType(oscarBoxbase.getOscartype());
    }

    public OscarBoxbase(Point point, Point point2) {
        this();
        this.llb = point;
        this.urt = point2;
    }

    public OscarBoxbase(String string) throws SQLException {
        this();
        ((OscarObject)this).setValue(string);
    }

    @Override
    public void setValue(String object) throws SQLException {
        String[] stringArray;
        int n2 = 0;
        if (((String)(object = ((String)object).trim())).startsWith("SRID=")) {
            stringArray = GeometryBuilder.splitSRID((String)object);
            object = stringArray[1].trim();
            n2 = Geometry.parseSRID(Integer.parseInt(stringArray[0].substring(5)));
        }
        if (((String)object).startsWith((String)(stringArray = this.getPrefix()))) {
            object = ((String)object).substring(stringArray.length()).trim();
        }
        object = GeometryTokenizer.removeLeadingAndTrailingStrings(((String)object).trim(), "(", ")");
        object = GeometryTokenizer.tokenize((String)object, ',');
        this.llb = new Point((String)object.get(0));
        this.urt = new Point((String)object.get(1));
        if (n2 != 0) {
            this.llb.setSrid(n2);
            this.urt.setSrid(n2);
        }
    }

    @Override
    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        this.outerWKT(stringBuffer);
        return stringBuffer.toString();
    }

    private void outerWKT(StringBuffer stringBuffer) {
        stringBuffer.append(this.getPrefix());
        stringBuffer.append('(');
        this.llb.innerWKT(stringBuffer);
        stringBuffer.append(',');
        this.urt.innerWKT(stringBuffer);
        stringBuffer.append(')');
    }

    @Override
    public String toString() {
        return ((OscarObject)this).getValue();
    }

    public Point getLLB() {
        return this.llb;
    }

    public Point getURT() {
        return this.urt;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OscarBoxbase) {
            object = (OscarBoxbase)object;
            return OscarBoxbase.compareLazyDim(this.llb, ((OscarBoxbase)object).llb) && OscarBoxbase.compareLazyDim(this.urt, ((OscarBoxbase)object).urt);
        }
        return super.equals(object);
    }

    protected static boolean compareLazyDim(Point point, Point point2) {
        return !(point.getX() != point2.getX() || point.getY() != point2.getY() || (point.dimension != 2 && point.getZ() != 0.0 || point2.dimension != 2 && point2.getZ() != 0.0) && point.getZ() != point2.getZ());
    }

    @Override
    public Object clone() {
        OscarBoxbase oscarBoxbase = this.newInstance();
        this.newInstance().llb = this.llb;
        oscarBoxbase.urt = this.urt;
        oscarBoxbase.setType(this.type);
        return oscarBoxbase;
    }

    protected abstract OscarBoxbase newInstance();
}

