/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarCircle
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6507295651335704535L;
    private OscarPoint center;
    private double radius;

    public OscarCircle(double d2, double d3, double d4) {
        this(new OscarPoint(d2, d3), d4);
    }

    public OscarCircle(OscarPoint oscarPoint, double d2) {
        this();
        this.center = oscarPoint;
        this.radius = d2;
    }

    public OscarCircle(String string) throws SQLException {
        this();
        ((OscarObject)this).setValue(string);
    }

    public OscarCircle() {
        this.setType("circle");
    }

    @Override
    public void setValue(String string) throws SQLException {
        OscarTokenizer oscarTokenizer = new OscarTokenizer(OscarTokenizer.removeAngle(string), ',');
        if (oscarTokenizer.getSize() != 2) {
            throw new SQLException("Conversion to type" + this.type + "failed: " + string);
        }
        try {
            this.center = new OscarPoint(oscarTokenizer.getToken(0));
            this.radius = Double.parseDouble(oscarTokenizer.getToken(1));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Conversion to type" + this.type + "failed: " + string);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OscarCircle) {
            object = (OscarCircle)object;
            return ((OscarObject)((OscarCircle)object).center).equals(this.center) && ((OscarCircle)object).radius == this.radius;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.radius);
        return (int)((long)((OscarObject)this.center).hashCode() ^ l2 ^ l2 >>> 32);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OscarCircle oscarCircle = (OscarCircle)super.clone();
        if (oscarCircle.center != null) {
            oscarCircle.center = (OscarPoint)oscarCircle.center.clone();
        }
        return oscarCircle;
    }

    @Override
    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

