/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarLseg;
import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarLine
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -664131953262651275L;
    private double a;
    private double b;
    private double c;

    public OscarLine(double d2, double d3, double d4) {
        this();
        this.a = d2;
        this.b = d3;
        this.c = d4;
    }

    public OscarLine(double d2, double d3, double d4, double d5) {
        this();
        if (d2 == d4) {
            this.a = -1.0;
            this.b = 0.0;
        } else {
            this.a = (d5 - d3) / (d4 - d2);
            this.b = -1.0;
        }
        this.c = d3 - this.a * d2;
    }

    public OscarLine(OscarPoint oscarPoint, OscarPoint oscarPoint2) {
        this(oscarPoint.x, oscarPoint.y, oscarPoint2.x, oscarPoint2.y);
    }

    public OscarLine(OscarLseg oscarLseg) {
        this(oscarLseg.getPoint()[0], oscarLseg.getPoint()[1]);
    }

    public OscarLine(String string) throws SQLException {
        this();
        ((OscarObject)this).setValue(string);
    }

    public OscarLine() {
        this.setType("line");
    }

    @Override
    public void setValue(String object) throws SQLException {
        if (((String)object).trim().startsWith("{")) {
            OscarTokenizer oscarTokenizer = new OscarTokenizer(OscarTokenizer.removeCurlyBrace((String)object), ',');
            if (oscarTokenizer.getSize() != 3) {
                throw new SQLException("Conversion to type " + this.type + " failed: " + (String)object);
            }
            this.a = Double.parseDouble(oscarTokenizer.getToken(0));
            this.b = Double.parseDouble(oscarTokenizer.getToken(1));
            this.c = Double.parseDouble(oscarTokenizer.getToken(2));
            return;
        }
        if (((String)object).trim().startsWith("[")) {
            Object object2 = new OscarTokenizer(OscarTokenizer.removeBox((String)object), ',');
            if (((OscarTokenizer)object2).getSize() != 2) {
                throw new SQLException("Conversion to type " + this.type + " failed: " + (String)object);
            }
            object = new OscarPoint(((OscarTokenizer)object2).getToken(0));
            object2 = new OscarPoint(((OscarTokenizer)object2).getToken(1));
            this.a = ((OscarPoint)object2).x - ((OscarPoint)object).x;
            this.b = ((OscarPoint)object2).y - ((OscarPoint)object).y;
            this.c = ((OscarPoint)object).y;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = (OscarLine)object;
        return Double.compare(((OscarLine)object).a, this.a) == 0 && Double.compare(((OscarLine)object).b, this.b) == 0 && Double.compare(((OscarLine)object).c, this.c) == 0;
    }

    @Override
    public int hashCode() {
        long l2;
        int n2 = super.hashCode();
        long l3 = l2 = Double.doubleToLongBits(this.a);
        n2 = n2 * 31 + (int)(l3 ^ l3 >>> 32);
        long l4 = l2 = Double.doubleToLongBits(this.b);
        n2 = n2 * 31 + (int)(l4 ^ l4 >>> 32);
        long l5 = l2 = Double.doubleToLongBits(this.c);
        n2 = n2 * 31 + (int)(l5 ^ l5 >>> 32);
        return n2;
    }

    @Override
    public String getValue() {
        return "{" + this.a + "," + this.b + "," + this.c + "}";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

