/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarPath
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8171736651491981495L;
    private boolean open;
    private OscarPoint[] points;

    public OscarPath(OscarPoint[] oscarPointArray, boolean bl) {
        this();
        this.points = oscarPointArray;
        this.open = bl;
    }

    public OscarPath() {
        this.setType("path");
    }

    public OscarPath(String string) throws SQLException {
        this();
        ((OscarObject)this).setValue(string);
    }

    @Override
    public void setValue(String object) throws SQLException {
        if (((String)object).startsWith("[") && ((String)object).endsWith("]")) {
            this.open = true;
            object = OscarTokenizer.removeBox((String)object);
        } else if (((String)object).startsWith("(") && ((String)object).endsWith(")")) {
            this.open = false;
            object = OscarTokenizer.removePara((String)object);
        } else {
            throw new SQLException("Cannot tell if path is open or closed: " + (String)object);
        }
        object = new OscarTokenizer((String)object, ',');
        int n2 = ((OscarTokenizer)object).getSize();
        this.points = new OscarPoint[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.points[i2] = new OscarPoint(((OscarTokenizer)object).getToken(i2));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OscarPath) {
            object = (OscarPath)object;
            if (((OscarPath)object).points.length != this.points.length) {
                return false;
            }
            if (((OscarPath)object).open != this.open) {
                return false;
            }
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (((OscarObject)this.points[i2]).equals(((OscarPath)object).points[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.points.length && i2 < 5; ++i2) {
            n2 ^= ((OscarObject)this.points[i2]).hashCode();
        }
        return n2;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OscarPath oscarPath = (OscarPath)super.clone();
        if (oscarPath.points != null) {
            oscarPath.points = (OscarPoint[])oscarPath.points.clone();
            for (int i2 = 0; i2 < oscarPath.points.length; ++i2) {
                oscarPath.points[i2] = (OscarPoint)oscarPath.points[i2].clone();
            }
        }
        return oscarPath;
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder(this.open ? "[" : "(");
        for (int i2 = 0; i2 < this.points.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.points[i2].toString());
        }
        stringBuilder.append(this.open ? "]" : ")");
        return stringBuilder.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

