/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.util.OscarTokenizer;
import com.oscar.util.converter.ByteConverter;
import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarPoint
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6446184397348989573L;
    protected double x;
    protected double y;

    public OscarPoint(double d2, double d3) {
        this();
        this.x = d2;
        this.y = d3;
    }

    public OscarPoint(String string) throws SQLException {
        this();
        ((OscarObject)this).setValue(string);
    }

    public OscarPoint() {
        this.setType("point");
    }

    @Override
    public void setValue(String object) throws SQLException {
        object = new OscarTokenizer(OscarTokenizer.removePara((String)object), ',');
        try {
            this.x = Double.parseDouble(((OscarTokenizer)object).getToken(0));
            this.y = Double.parseDouble(((OscarTokenizer)object).getToken(1));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(numberFormatException.getMessage());
        }
    }

    public void setByteValue(byte[] byArray, int n2) {
        this.x = ByteConverter.float8(byArray, n2);
        this.y = ByteConverter.float8(byArray, n2 + 8);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OscarPoint) {
            object = (OscarPoint)object;
            return this.x == ((OscarPoint)object).x && this.y == ((OscarPoint)object).y;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.x);
        long l3 = Double.doubleToLongBits(this.y);
        return (int)(l2 ^ l3 ^ l2 >>> 32 ^ l3 >>> 32);
    }

    @Override
    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    public int lengthInBytes() {
        return 16;
    }

    public void toBytes(byte[] byArray, int n2) {
        ByteConverter.float8(byArray, n2, this.x);
        ByteConverter.float8(byArray, n2 + 8, this.y);
    }

    public void translate(int n2, int n3) {
        this.translate((double)n2, (double)n3);
    }

    public void translate(double d2, double d3) {
        this.x += d2;
        this.y += d3;
    }

    public void move(int n2, int n3) {
        this.setLocation(n2, n3);
    }

    public void move(double d2, double d3) {
        this.x = d2;
        this.y = d3;
    }

    public void setLocation(int n2, int n3) {
        this.move((double)n2, (double)n3);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }
}

