/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.OscarPoint;
import com.oscar.util.OscarTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarPolygon
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5596122553333897668L;
    private OscarPoint[] points;

    public OscarPolygon(OscarPoint[] oscarPointArray) {
        this();
        this.points = oscarPointArray;
    }

    public OscarPolygon(String string) throws SQLException {
        this();
        ((OscarObject)this).setValue(string);
    }

    public OscarPolygon() {
        this.setType("polygon");
    }

    @Override
    public void setValue(String object) throws SQLException {
        object = new OscarTokenizer(OscarTokenizer.removePara((String)object), ',');
        int n2 = ((OscarTokenizer)object).getSize();
        this.points = new OscarPoint[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.points[i2] = new OscarPoint(((OscarTokenizer)object).getToken(i2));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OscarPolygon) {
            object = (OscarPolygon)object;
            if (((OscarPolygon)object).points.length != this.points.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (((OscarObject)this.points[i2]).equals(((OscarPolygon)object).points[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.points.length && i2 < 5; ++i2) {
            n2 ^= ((OscarObject)this.points[i2]).hashCode();
        }
        return n2;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OscarPolygon oscarPolygon = (OscarPolygon)super.clone();
        if (oscarPolygon.points != null) {
            oscarPolygon.points = (OscarPoint[])oscarPolygon.points.clone();
            for (int i2 = 0; i2 < oscarPolygon.points.length; ++i2) {
                if (oscarPolygon.points[i2] == null) continue;
                oscarPolygon.points[i2] = (OscarPoint)oscarPolygon.points[i2].clone();
            }
        }
        return oscarPolygon;
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i2 = 0; i2 < this.points.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.points[i2].toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

