/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.gis.binary.ShapeBinaryParser;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;

public class OscarShapeGeometry
extends OscarObject
implements Shape {
    private static final long serialVersionUID = 256L;
    static final ShapeBinaryParser parser = new ShapeBinaryParser();
    private final GeneralPath path;
    private int srid;

    public OscarShapeGeometry() {
        this.setType("geometry");
        this.path = new GeneralPath(0);
    }

    public OscarShapeGeometry(GeneralPath generalPath, int n2) {
        this.setType("geometry");
        this.path = generalPath;
        this.srid = n2;
    }

    public OscarShapeGeometry(String string) throws SQLException {
        this();
        ((OscarObject)this).setValue(string);
    }

    @Override
    public void setValue(String string) throws SQLException {
        this.srid = parser.parse(string, this.path);
    }

    @Override
    public String toString() {
        return "OscarShapeGeometry " + this.path.toString();
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OscarShapeGeometry) {
            return ((OscarShapeGeometry)object).path.equals(this.path);
        }
        return super.equals(object);
    }

    public int getSRID() {
        return this.srid;
    }

    @Override
    public boolean contains(double d2, double d3) {
        return this.path.contains(d2, d3);
    }

    @Override
    public boolean contains(double d2, double d3, double d4, double d5) {
        return this.path.contains(d2, d3, d4, d5);
    }

    @Override
    public boolean intersects(double d2, double d3, double d4, double d5) {
        return this.path.intersects(d2, d3, d4, d5);
    }

    @Override
    public Rectangle getBounds() {
        return this.path.getBounds();
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.path.contains(point2D);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.path.contains(rectangle2D);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.path.intersects(rectangle2D);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.path.getPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return this.path.getPathIterator(affineTransform, d2);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

