/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.binary;

import com.oscar.gis.binary.ByteGetter;
import com.oscar.gis.binary.ValueGetter;
import com.oscar.gis.util.Geometry;
import com.oscar.gis.util.GeometryCollection;
import com.oscar.gis.util.LineString;
import com.oscar.gis.util.LinearRing;
import com.oscar.gis.util.MultiLineString;
import com.oscar.gis.util.MultiPoint;
import com.oscar.gis.util.MultiPolygon;
import com.oscar.gis.util.Point;
import com.oscar.gis.util.Polygon;

public class BinaryParser {
    public static ValueGetter valueGetterForEndian(ByteGetter byteGetter) {
        if (byteGetter.get(0) == 0) {
            return new ValueGetter.XDR(byteGetter);
        }
        if (byteGetter.get(0) == 1) {
            return new ValueGetter.NDR(byteGetter);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + byteGetter.get(0));
    }

    public synchronized Geometry parse(String object) {
        object = new ByteGetter.StringByteGetter((String)object);
        return this.parseGeometry(BinaryParser.valueGetterForEndian((ByteGetter)object));
    }

    public synchronized Geometry parse(byte[] object) {
        object = new ByteGetter.BinaryByteGetter((byte[])object);
        return this.parseGeometry(BinaryParser.valueGetterForEndian((ByteGetter)object));
    }

    protected Geometry parseGeometry(ValueGetter object) {
        int n2 = ((ValueGetter)object).getByte();
        if (n2 != ((ValueGetter)object).endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        n2 = ((ValueGetter)object).getInt();
        int n3 = n2 & 0x1FFFFFFF;
        boolean bl = (n2 & Integer.MIN_VALUE) != 0;
        boolean bl2 = (n2 & 0x40000000) != 0;
        n2 = (n2 & 0x20000000) != 0 ? 1 : 0;
        int n4 = 0;
        if (n2 != 0) {
            n4 = Geometry.parseSRID(((ValueGetter)object).getInt());
        }
        switch (n3) {
            case 1: {
                object = this.parsePoint((ValueGetter)object, bl, bl2);
                break;
            }
            case 2: {
                object = this.parseLineString((ValueGetter)object, bl, bl2);
                break;
            }
            case 3: {
                object = this.parsePolygon((ValueGetter)object, bl, bl2);
                break;
            }
            case 4: {
                object = this.parseMultiPoint((ValueGetter)object);
                break;
            }
            case 5: {
                object = this.parseMultiLineString((ValueGetter)object);
                break;
            }
            case 6: {
                object = this.parseMultiPolygon((ValueGetter)object);
                break;
            }
            case 7: {
                object = this.parseCollection((ValueGetter)object);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + n3);
            }
        }
        if (n4 != 0) {
            ((Geometry)object).setSrid(n4);
        }
        return object;
    }

    private Point parsePoint(ValueGetter valueGetter, boolean bl, boolean bl2) {
        Point point;
        double d2 = valueGetter.getDouble();
        double d3 = valueGetter.getDouble();
        if (bl) {
            double d4 = valueGetter.getDouble();
            point = new Point(d2, d3, d4);
        } else {
            point = new Point(d2, d3);
        }
        if (bl2) {
            point.setM(valueGetter.getDouble());
        }
        return point;
    }

    private void parseGeometryArray(ValueGetter valueGetter, Geometry[] geometryArray) {
        for (int i2 = 0; i2 < geometryArray.length; ++i2) {
            geometryArray[i2] = this.parseGeometry(valueGetter);
        }
    }

    private Point[] parsePointArray(ValueGetter valueGetter, boolean bl, boolean bl2) {
        int n2 = valueGetter.getInt();
        Point[] pointArray = new Point[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            pointArray[i2] = this.parsePoint(valueGetter, bl, bl2);
        }
        return pointArray;
    }

    private MultiPoint parseMultiPoint(ValueGetter valueGetter) {
        Geometry[] geometryArray = new Point[valueGetter.getInt()];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new MultiPoint((Point[])geometryArray);
    }

    private LineString parseLineString(ValueGetter pointArray, boolean bl, boolean bl2) {
        pointArray = this.parsePointArray((ValueGetter)pointArray, bl, bl2);
        return new LineString(pointArray);
    }

    private LinearRing parseLinearRing(ValueGetter pointArray, boolean bl, boolean bl2) {
        pointArray = this.parsePointArray((ValueGetter)pointArray, bl, bl2);
        return new LinearRing(pointArray);
    }

    private Polygon parsePolygon(ValueGetter valueGetter, boolean bl, boolean bl2) {
        int n2 = valueGetter.getInt();
        LinearRing[] linearRingArray = new LinearRing[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            linearRingArray[i2] = this.parseLinearRing(valueGetter, bl, bl2);
        }
        return new Polygon(linearRingArray);
    }

    private MultiLineString parseMultiLineString(ValueGetter valueGetter) {
        int n2 = valueGetter.getInt();
        Geometry[] geometryArray = new LineString[n2];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new MultiLineString((LineString[])geometryArray);
    }

    private MultiPolygon parseMultiPolygon(ValueGetter valueGetter) {
        int n2 = valueGetter.getInt();
        Geometry[] geometryArray = new Polygon[n2];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new MultiPolygon((Polygon[])geometryArray);
    }

    private GeometryCollection parseCollection(ValueGetter valueGetter) {
        int n2 = valueGetter.getInt();
        Geometry[] geometryArray = new Geometry[n2];
        this.parseGeometryArray(valueGetter, geometryArray);
        return new GeometryCollection(geometryArray);
    }
}

