/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.binary;

import com.oscar.gis.binary.ByteSetter;
import com.oscar.gis.binary.ValueSetter;
import com.oscar.gis.util.Geometry;
import com.oscar.gis.util.GeometryCollection;
import com.oscar.gis.util.LineString;
import com.oscar.gis.util.LinearRing;
import com.oscar.gis.util.MultiLineString;
import com.oscar.gis.util.MultiPoint;
import com.oscar.gis.util.MultiPolygon;
import com.oscar.gis.util.Point;
import com.oscar.gis.util.Polygon;

public class BinaryWriter {
    public static ValueSetter valueSetterForEndian(ByteSetter byteSetter, byte by) {
        if (by == 0) {
            return new ValueSetter.XDR(byteSetter);
        }
        if (by == 1) {
            return new ValueSetter.NDR(byteSetter);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + by);
    }

    public synchronized String writeHexed(Geometry geometry, byte by) {
        int n2 = this.estimateBytes(geometry);
        ByteSetter.StringByteSetter stringByteSetter = new ByteSetter.StringByteSetter(n2);
        this.writeGeometry(geometry, BinaryWriter.valueSetterForEndian(stringByteSetter, by));
        return stringByteSetter.result();
    }

    public synchronized String writeHexed(Geometry geometry) {
        return this.writeHexed(geometry, (byte)1);
    }

    public synchronized byte[] writeBinary(Geometry geometry, byte by) {
        int n2 = this.estimateBytes(geometry);
        ByteSetter.BinaryByteSetter binaryByteSetter = new ByteSetter.BinaryByteSetter(n2);
        this.writeGeometry(geometry, BinaryWriter.valueSetterForEndian(binaryByteSetter, by));
        return binaryByteSetter.result();
    }

    public synchronized byte[] writeBinary(Geometry geometry) {
        return this.writeBinary(geometry, (byte)1);
    }

    protected void writeGeometry(Geometry geometry, ValueSetter valueSetter) {
        ValueSetter valueSetter2 = valueSetter;
        valueSetter2.setByte(valueSetter2.endian);
        int n2 = geometry.type;
        if (geometry.dimension == 3) {
            n2 |= Integer.MIN_VALUE;
        }
        if (geometry.haveMeasure) {
            n2 |= 0x40000000;
        }
        if (geometry.getSrid() != 0) {
            n2 |= 0x20000000;
        }
        valueSetter.setInt(n2);
        if (geometry.getSrid() != 0) {
            valueSetter.setInt(geometry.getSrid());
        }
        switch (geometry.type) {
            case 1: {
                this.writePoint((Point)geometry, valueSetter);
                return;
            }
            case 2: {
                this.writeLineString((LineString)geometry, valueSetter);
                return;
            }
            case 3: {
                this.writePolygon((Polygon)geometry, valueSetter);
                return;
            }
            case 4: {
                this.writeMultiPoint((MultiPoint)geometry, valueSetter);
                return;
            }
            case 5: {
                this.writeMultiLineString((MultiLineString)geometry, valueSetter);
                return;
            }
            case 6: {
                this.writeMultiPolygon((MultiPolygon)geometry, valueSetter);
                return;
            }
            case 7: {
                this.writeCollection((GeometryCollection)geometry, valueSetter);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown Geometry Type: " + geometry.type);
    }

    private void writePoint(Point point, ValueSetter valueSetter) {
        valueSetter.setDouble(point.getX());
        valueSetter.setDouble(point.getY());
        if (point.dimension == 3) {
            valueSetter.setDouble(point.getZ());
        }
        if (point.haveMeasure) {
            valueSetter.setDouble(point.getM());
        }
    }

    private void writeGeometryArray(Geometry[] geometryArray, ValueSetter valueSetter) {
        for (int i2 = 0; i2 < geometryArray.length; ++i2) {
            this.writeGeometry(geometryArray[i2], valueSetter);
        }
    }

    private void writePointArray(Point[] pointArray, ValueSetter valueSetter) {
        valueSetter.setInt(pointArray.length);
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            this.writePoint(pointArray[i2], valueSetter);
        }
    }

    private void writeMultiPoint(MultiPoint multiPoint, ValueSetter valueSetter) {
        valueSetter.setInt(((Geometry)multiPoint).numPoints());
        this.writeGeometryArray(multiPoint.getPoints(), valueSetter);
    }

    private void writeLineString(LineString lineString, ValueSetter valueSetter) {
        this.writePointArray(lineString.getPoints(), valueSetter);
    }

    private void writeLinearRing(LinearRing linearRing, ValueSetter valueSetter) {
        this.writePointArray(linearRing.getPoints(), valueSetter);
    }

    private void writePolygon(Polygon polygon, ValueSetter valueSetter) {
        valueSetter.setInt(polygon.numRings());
        for (int i2 = 0; i2 < polygon.numRings(); ++i2) {
            this.writeLinearRing(polygon.getRing(i2), valueSetter);
        }
    }

    private void writeMultiLineString(MultiLineString multiLineString, ValueSetter valueSetter) {
        valueSetter.setInt(multiLineString.numLines());
        this.writeGeometryArray(multiLineString.getLines(), valueSetter);
    }

    private void writeMultiPolygon(MultiPolygon multiPolygon, ValueSetter valueSetter) {
        valueSetter.setInt(multiPolygon.numPolygons());
        this.writeGeometryArray(multiPolygon.getPolygons(), valueSetter);
    }

    private void writeCollection(GeometryCollection geometryCollection, ValueSetter valueSetter) {
        valueSetter.setInt(geometryCollection.numGeoms());
        this.writeGeometryArray(geometryCollection.getGeometries(), valueSetter);
    }

    protected int estimateBytes(Geometry geometry) {
        int n2 = 0;
        ++n2;
        n2 += 4;
        if (geometry.getSrid() != 0) {
            n2 += 4;
        }
        switch (geometry.type) {
            case 1: {
                n2 += this.estimatePoint((Point)geometry);
                break;
            }
            case 2: {
                n2 += this.estimateLineString((LineString)geometry);
                break;
            }
            case 3: {
                n2 += this.estimatePolygon((Polygon)geometry);
                break;
            }
            case 4: {
                n2 += this.estimateMultiPoint((MultiPoint)geometry);
                break;
            }
            case 5: {
                n2 += this.estimateMultiLineString((MultiLineString)geometry);
                break;
            }
            case 6: {
                n2 += this.estimateMultiPolygon((MultiPolygon)geometry);
                break;
            }
            case 7: {
                n2 += this.estimateCollection((GeometryCollection)geometry);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type: " + geometry.type);
            }
        }
        return n2;
    }

    private int estimatePoint(Point point) {
        int n2 = 16;
        if (point.dimension == 3) {
            n2 += 8;
        }
        if (point.haveMeasure) {
            n2 += 8;
        }
        return n2;
    }

    private int estimateGeometryArray(Geometry[] geometryArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < geometryArray.length; ++i2) {
            n2 += this.estimateBytes(geometryArray[i2]);
        }
        return n2;
    }

    private int estimatePointArray(Point[] pointArray) {
        int n2 = 4;
        if (pointArray.length > 0) {
            n2 = 4 + pointArray.length * this.estimatePoint(pointArray[0]);
        }
        return n2;
    }

    private int estimateMultiPoint(MultiPoint multiPoint) {
        int n2 = 4;
        if (((Geometry)multiPoint).numPoints() > 0) {
            n2 = 4 + ((Geometry)multiPoint).numPoints() * this.estimateBytes(((Geometry)multiPoint).getFirstPoint());
        }
        return n2;
    }

    private int estimateLineString(LineString lineString) {
        return this.estimatePointArray(lineString.getPoints());
    }

    private int estimateLinearRing(LinearRing linearRing) {
        return this.estimatePointArray(linearRing.getPoints());
    }

    private int estimatePolygon(Polygon polygon) {
        int n2 = 4;
        for (int i2 = 0; i2 < polygon.numRings(); ++i2) {
            n2 += this.estimateLinearRing(polygon.getRing(i2));
        }
        return n2;
    }

    private int estimateMultiLineString(MultiLineString multiLineString) {
        return 4 + this.estimateGeometryArray(multiLineString.getLines());
    }

    private int estimateMultiPolygon(MultiPolygon multiPolygon) {
        return 4 + this.estimateGeometryArray(multiPolygon.getPolygons());
    }

    private int estimateCollection(GeometryCollection geometryCollection) {
        return 4 + this.estimateGeometryArray(geometryCollection.getGeometries());
    }
}

