/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.binary;

public abstract class ByteSetter {
    public abstract void set(byte var1, int var2);

    public static class StringByteSetter
    extends ByteSetter {
        private static final char[] hextypes = "0123456789ABCDEF".toCharArray();
        private char[] rep;

        public StringByteSetter(int n2) {
            this.rep = new char[n2 << 1];
        }

        @Override
        public void set(byte by, int n2) {
            this.rep[n2 <<= 1] = hextypes[by >>> 4 & 0xF];
            this.rep[n2 + 1] = hextypes[by & 0xF];
        }

        public char[] resultAsArray() {
            return this.rep;
        }

        public String result() {
            return new String(this.rep);
        }

        public String toString() {
            return new String(this.rep);
        }
    }

    public static class BinaryByteSetter
    extends ByteSetter {
        private byte[] array;

        public BinaryByteSetter(int n2) {
            this.array = new byte[n2];
        }

        @Override
        public void set(byte by, int n2) {
            this.array[n2] = by;
        }

        public byte[] result() {
            return this.array;
        }

        public String toString() {
            char[] cArray = new char[this.array.length];
            for (int i2 = 0; i2 < this.array.length; ++i2) {
                cArray[i2] = (char)(this.array[i2] & 0xFF);
            }
            return new String(cArray);
        }
    }
}

