/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.binary;

import com.oscar.gis.binary.ByteGetter;
import com.oscar.gis.binary.ValueGetter;
import com.oscar.gis.util.Geometry;
import java.awt.geom.GeneralPath;

public class ShapeBinaryParser {
    public static ValueGetter valueGetterForEndian(ByteGetter byteGetter) {
        if (byteGetter.get(0) == 0) {
            return new ValueGetter.XDR(byteGetter);
        }
        if (byteGetter.get(0) == 1) {
            return new ValueGetter.NDR(byteGetter);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + byteGetter.get(0));
    }

    public synchronized int parse(String object, GeneralPath generalPath) {
        object = new ByteGetter.StringByteGetter((String)object);
        return this.parseGeometry(ShapeBinaryParser.valueGetterForEndian((ByteGetter)object), generalPath);
    }

    public synchronized int parse(byte[] object, GeneralPath generalPath) {
        object = new ByteGetter.BinaryByteGetter((byte[])object);
        return this.parseGeometry(ShapeBinaryParser.valueGetterForEndian((ByteGetter)object), generalPath);
    }

    protected int parseGeometry(ValueGetter valueGetter, GeneralPath generalPath) {
        int n2 = valueGetter.getByte();
        if (n2 != valueGetter.endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        n2 = valueGetter.getInt();
        int n3 = n2 & 0x1FFFFFFF;
        boolean bl = (n2 & Integer.MIN_VALUE) != 0;
        boolean bl2 = (n2 & 0x40000000) != 0;
        n2 = (n2 & 0x20000000) != 0 ? 1 : 0;
        int n4 = 0;
        if (n2 != 0) {
            n4 = Geometry.parseSRID(valueGetter.getInt());
        }
        switch (n3) {
            case 1: {
                this.parsePoint(valueGetter, bl, bl2, generalPath);
                break;
            }
            case 2: {
                this.parseLineString(valueGetter, bl, bl2, generalPath);
                break;
            }
            case 3: {
                this.parsePolygon(valueGetter, bl, bl2, generalPath);
                break;
            }
            case 4: {
                this.parseMultiPoint(valueGetter, generalPath);
                break;
            }
            case 5: {
                this.parseMultiLineString(valueGetter, generalPath);
                break;
            }
            case 6: {
                this.parseMultiPolygon(valueGetter, generalPath);
                break;
            }
            case 7: {
                this.parseCollection(valueGetter, generalPath);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type!");
            }
        }
        return n4;
    }

    private void parsePoint(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        double d2 = valueGetter.getDouble();
        double d3 = valueGetter.getDouble();
        generalPath.moveTo((float)d2, (float)d3);
        generalPath.lineTo((float)d2, (float)d3);
        this.skipZM(valueGetter, bl, bl2);
    }

    private void skipZM(ValueGetter valueGetter, boolean bl, boolean bl2) {
        if (bl) {
            valueGetter.getDouble();
        }
        if (bl2) {
            valueGetter.getDouble();
        }
    }

    private void parseGeometryArray(ValueGetter valueGetter, int n2, GeneralPath generalPath) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.parseGeometry(valueGetter, generalPath);
        }
    }

    private void parseCS(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        int n2 = valueGetter.getInt();
        if (n2 > 0) {
            generalPath.moveTo((float)valueGetter.getDouble(), (float)valueGetter.getDouble());
            this.skipZM(valueGetter, bl, bl2);
            for (int i2 = 1; i2 < n2; ++i2) {
                generalPath.lineTo((float)valueGetter.getDouble(), (float)valueGetter.getDouble());
                this.skipZM(valueGetter, bl, bl2);
            }
        }
    }

    private void parseMultiPoint(ValueGetter valueGetter, GeneralPath generalPath) {
        ValueGetter valueGetter2 = valueGetter;
        this.parseGeometryArray(valueGetter2, valueGetter2.getInt(), generalPath);
    }

    private void parseLineString(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        this.parseCS(valueGetter, bl, bl2, generalPath);
    }

    private void parseLinearRing(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        this.parseCS(valueGetter, bl, bl2, generalPath);
        generalPath.closePath();
    }

    private void parsePolygon(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        int n2 = valueGetter.getInt() - 1;
        this.parseLinearRing(valueGetter, bl, bl2, generalPath);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.parseLinearRing(valueGetter, bl, bl2, generalPath);
        }
    }

    private void parseMultiLineString(ValueGetter valueGetter, GeneralPath generalPath) {
        int n2 = valueGetter.getInt();
        this.parseGeometryArray(valueGetter, n2, generalPath);
    }

    private void parseMultiPolygon(ValueGetter valueGetter, GeneralPath generalPath) {
        int n2 = valueGetter.getInt();
        this.parseGeometryArray(valueGetter, n2, generalPath);
    }

    private void parseCollection(ValueGetter valueGetter, GeneralPath generalPath) {
        int n2 = valueGetter.getInt();
        this.parseGeometryArray(valueGetter, n2, generalPath);
    }
}

