/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.binary;

import com.oscar.gis.binary.ByteGetter;

public abstract class ValueGetter {
    ByteGetter data;
    int position;
    public final byte endian;

    public ValueGetter(ByteGetter byteGetter, byte by) {
        this.data = byteGetter;
        this.endian = by;
    }

    public byte getByte() {
        return (byte)this.data.get(this.position++);
    }

    public int getInt() {
        ValueGetter valueGetter = this;
        int n2 = valueGetter.getInt(valueGetter.position);
        this.position += 4;
        return n2;
    }

    public long getLong() {
        ValueGetter valueGetter = this;
        long l2 = valueGetter.getLong(valueGetter.position);
        this.position += 8;
        return l2;
    }

    protected abstract int getInt(int var1);

    protected abstract long getLong(int var1);

    public double getDouble() {
        long l2 = this.getLong();
        return Double.longBitsToDouble(l2);
    }

    public static class NDR
    extends ValueGetter {
        public static final byte NUMBER = 1;

        public NDR(ByteGetter byteGetter) {
            super(byteGetter, (byte)1);
        }

        @Override
        protected int getInt(int n2) {
            return (this.data.get(n2 + 3) << 24) + (this.data.get(n2 + 2) << 16) + (this.data.get(n2 + 1) << 8) + this.data.get(n2);
        }

        @Override
        protected long getLong(int n2) {
            return ((long)this.data.get(n2 + 7) << 56) + ((long)this.data.get(n2 + 6) << 48) + ((long)this.data.get(n2 + 5) << 40) + ((long)this.data.get(n2 + 4) << 32) + ((long)this.data.get(n2 + 3) << 24) + ((long)this.data.get(n2 + 2) << 16) + ((long)this.data.get(n2 + 1) << 8) + (long)this.data.get(n2);
        }
    }

    public static class XDR
    extends ValueGetter {
        public static final byte NUMBER = 0;

        public XDR(ByteGetter byteGetter) {
            super(byteGetter, (byte)0);
        }

        @Override
        protected int getInt(int n2) {
            return (this.data.get(n2) << 24) + (this.data.get(n2 + 1) << 16) + (this.data.get(n2 + 2) << 8) + this.data.get(n2 + 3);
        }

        @Override
        protected long getLong(int n2) {
            return ((long)this.data.get(n2) << 56) + ((long)this.data.get(n2 + 1) << 48) + ((long)this.data.get(n2 + 2) << 40) + ((long)this.data.get(n2 + 3) << 32) + ((long)this.data.get(n2 + 4) << 24) + ((long)this.data.get(n2 + 5) << 16) + ((long)this.data.get(n2 + 6) << 8) + (long)this.data.get(n2 + 7);
        }
    }
}

