/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.binary;

import com.oscar.gis.binary.ByteSetter;

public abstract class ValueSetter {
    ByteSetter data;
    int position = 0;
    public final byte endian;

    public ValueSetter(ByteSetter byteSetter, byte by) {
        this.data = byteSetter;
        this.endian = by;
    }

    public void setByte(byte by) {
        this.data.set(by, this.position);
        ++this.position;
    }

    public void setInt(int n2) {
        this.setInt(n2, this.position);
        this.position += 4;
    }

    public void setLong(long l2) {
        this.setLong(l2, this.position);
        this.position += 8;
    }

    protected abstract void setInt(int var1, int var2);

    protected abstract void setLong(long var1, int var3);

    public void setDouble(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        this.setLong(l2);
    }

    public String toString() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        string = string.substring(n2 + 1);
        return string + "('" + (this.data == null ? "NULL" : this.data.toString() + "')");
    }

    public static class NDR
    extends ValueSetter {
        public static final byte NUMBER = 1;

        public NDR(ByteSetter byteSetter) {
            super(byteSetter, (byte)1);
        }

        @Override
        protected void setInt(int n2, int n3) {
            this.data.set((byte)(n2 >>> 24), n3 + 3);
            this.data.set((byte)(n2 >>> 16), n3 + 2);
            this.data.set((byte)(n2 >>> 8), n3 + 1);
            this.data.set((byte)n2, n3);
        }

        @Override
        protected void setLong(long l2, int n2) {
            this.data.set((byte)(l2 >>> 56), n2 + 7);
            this.data.set((byte)(l2 >>> 48), n2 + 6);
            this.data.set((byte)(l2 >>> 40), n2 + 5);
            this.data.set((byte)(l2 >>> 32), n2 + 4);
            this.data.set((byte)(l2 >>> 24), n2 + 3);
            this.data.set((byte)(l2 >>> 16), n2 + 2);
            this.data.set((byte)(l2 >>> 8), n2 + 1);
            this.data.set((byte)l2, n2);
        }
    }

    public static class XDR
    extends ValueSetter {
        public static final byte NUMBER = 0;

        public XDR(ByteSetter byteSetter) {
            super(byteSetter, (byte)0);
        }

        @Override
        protected void setInt(int n2, int n3) {
            this.data.set((byte)(n2 >>> 24), n3);
            this.data.set((byte)(n2 >>> 16), n3 + 1);
            this.data.set((byte)(n2 >>> 8), n3 + 2);
            this.data.set((byte)n2, n3 + 3);
        }

        @Override
        protected void setLong(long l2, int n2) {
            this.data.set((byte)(l2 >>> 56), n2);
            this.data.set((byte)(l2 >>> 48), n2 + 1);
            this.data.set((byte)(l2 >>> 40), n2 + 2);
            this.data.set((byte)(l2 >>> 32), n2 + 3);
            this.data.set((byte)(l2 >>> 24), n2 + 4);
            this.data.set((byte)(l2 >>> 16), n2 + 5);
            this.data.set((byte)(l2 >>> 8), n2 + 6);
            this.data.set((byte)l2, n2 + 7);
        }
    }
}

