/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.util;

import com.oscar.gis.util.Geometry;
import com.oscar.gis.util.GeometryTokenizer;
import com.oscar.gis.util.Point;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;

public abstract class ComposedGeom
extends Geometry {
    private static final long serialVersionUID = 256L;
    public static final Geometry[] EMPTY = new Geometry[0];
    protected Geometry[] subgeoms = EMPTY;
    boolean nohash = true;
    int hashcode = 0;

    public ComposedGeom(int n2) {
        super(n2);
    }

    public Geometry getSubGeometry(int n2) {
        return this.subgeoms[n2];
    }

    public int numGeoms() {
        return this.subgeoms.length;
    }

    protected ComposedGeom(int n2, Geometry[] geometryArray) {
        this(n2);
        this.subgeoms = geometryArray;
        if (geometryArray.length > 0) {
            this.dimension = geometryArray[0].dimension;
            this.haveMeasure = geometryArray[0].haveMeasure;
            return;
        }
        this.dimension = 0;
    }

    protected ComposedGeom(int n2, String string, boolean bl) throws SQLException {
        super(n2);
        string = this.initSRID(string);
        String string2 = this.getTypeString();
        if (string.indexOf(string2) == 0) {
            int n3 = string2.length();
            if (string.charAt(n3) == 'M') {
                ++n3;
                bl = true;
            }
            string = string.substring(n3).trim();
        } else if (string.charAt(0) != '(') {
            throw new SQLException("Error parsing a " + string2 + " out of " + string);
        }
        if (string.equals("(EMPTY)")) {
            return;
        }
        Object object = GeometryTokenizer.removeLeadingAndTrailingStrings(string, "(", ")");
        object = GeometryTokenizer.tokenize((String)object, ',');
        int n4 = object.size();
        this.subgeoms = this.createSubGeomArray(n4);
        for (int i2 = 0; i2 < n4; ++i2) {
            this.subgeoms[i2] = this.createSubGeomInstance((String)object.get(i2), bl);
        }
        this.dimension = this.subgeoms[0].dimension;
        this.haveMeasure = this.subgeoms[0].haveMeasure;
    }

    protected abstract Geometry createSubGeomInstance(String var1, boolean var2) throws SQLException;

    protected abstract Geometry[] createSubGeomArray(int var1);

    @Override
    protected boolean equalsintern(Geometry geometry) {
        geometry = (ComposedGeom)geometry;
        if (((ComposedGeom)geometry).subgeoms == null && this.subgeoms == null) {
            return true;
        }
        if (((ComposedGeom)geometry).subgeoms == null || this.subgeoms == null) {
            return false;
        }
        if (((ComposedGeom)geometry).subgeoms.length != this.subgeoms.length) {
            return false;
        }
        if (this.subgeoms.length == 0) {
            return true;
        }
        for (int i2 = 0; i2 < this.subgeoms.length; ++i2) {
            if (((ComposedGeom)geometry).subgeoms[i2].equalsintern(this.subgeoms[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int numPoints() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.subgeoms.length; ++i2) {
            n2 += this.subgeoms[i2].numPoints();
        }
        return n2;
    }

    @Override
    public Point getPoint(int n2) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative index not allowed");
        }
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        for (int i2 = 0; i2 < this.subgeoms.length; ++i2) {
            Geometry geometry = this.subgeoms[i2];
            int n3 = geometry.numPoints();
            if (n2 < n3) {
                return geometry.getPoint(n2);
            }
            n2 -= n3;
        }
        throw new ArrayIndexOutOfBoundsException("Index too large!");
    }

    @Override
    public Point getLastPoint() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        return this.subgeoms[this.subgeoms.length - 1].getLastPoint();
    }

    @Override
    public Point getFirstPoint() {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty Geometry has no Points!");
        }
        return this.subgeoms[0].getFirstPoint();
    }

    public Iterator iterator() {
        return Arrays.asList(this.subgeoms).iterator();
    }

    public boolean isEmpty() {
        return this.subgeoms == null || this.subgeoms.length == 0;
    }

    @Override
    protected void mediumWKT(StringBuffer stringBuffer) {
        if (this.subgeoms == null || this.subgeoms.length == 0) {
            stringBuffer.append(" EMPTY");
            return;
        }
        stringBuffer.append('(');
        this.innerWKT(stringBuffer);
        stringBuffer.append(')');
    }

    @Override
    protected void innerWKT(StringBuffer stringBuffer) {
        this.subgeoms[0].mediumWKT(stringBuffer);
        for (int i2 = 1; i2 < this.subgeoms.length; ++i2) {
            stringBuffer.append(',');
            this.subgeoms[i2].mediumWKT(stringBuffer);
        }
    }

    @Override
    public int hashCode() {
        if (this.nohash) {
            this.hashcode = super.hashCode() ^ this.subgeoms.hashCode();
            this.nohash = false;
        }
        return this.hashcode;
    }

    @Override
    public boolean checkConsistency() {
        if (super.checkConsistency()) {
            if (this.isEmpty()) {
                return true;
            }
            int n2 = this.dimension;
            boolean bl = this.haveMeasure;
            int n3 = this.getSrid();
            for (int i2 = 0; i2 < this.subgeoms.length; ++i2) {
                Geometry geometry = this.subgeoms[i2];
                if (geometry.checkConsistency() && geometry.dimension == n2 && geometry.haveMeasure == bl && geometry.getSrid() == n3) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setSrid(int n2) {
        super.setSrid(n2);
        for (int i2 = 0; i2 < this.subgeoms.length; ++i2) {
            this.subgeoms[i2].setSrid(n2);
        }
    }
}

